LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_arith.ALL;
USE ieee.std_logic_unsigned.ALL;
-- ========================================================
ENTITY urisc_tb IS END;
-- ========================================================
ARCHITECTURE fpga OF urisc_tb IS

-- ========= Unit under test definition: ==================
  COMPONENT urisc IS 
 PORT(clk      : IN  STD_LOGIC; -- System clock (clk=>CLOCK_50)
      reset    : IN  STD_LOGIC; -- Active low asynchronous reset (reset<=> KEY(0))
      in_port  : IN  STD_LOGIC_VECTOR(7 DOWNTO 0); -- Input port (in_port<=>SW)
      out_port : OUT STD_LOGIC_VECTOR(7 DOWNTO 0)); -- Output port (out_port<=>LEDR)
  END COMPONENT;                
             
-- === Signal definition with intial values: =============
  SIGNAL clk : STD_LOGIC := '0';
  SIGNAL reset : STD_LOGIC;   
-- I/O Ports:     
  SIGNAL in_port : STD_LOGIC_VECTOR (7 DOWNTO 0);
  SIGNAL out_port : STD_LOGIC_VECTOR (7 DOWNTO 0);
  
  CONSTANT T : TIME := 20 ns;

BEGIN
-- ========= Unit under test instantiation: ==================
    UUT : urisc
    PORT MAP (
        clk => clk,
        reset => reset,
        in_port  => in_port,
        out_port => out_port);
    
-- =============== Periodic signals: ======================
  clk <= NOT clk AFTER T/2;

-- ================= Add stimuli: =========================
  PROCESS  
  BEGIN
    -- ====================
    reset <= '1';
    in_port <= CONV_STD_LOGIC_VECTOR(5, 8);
    -- ====================
    WAIT FOR 105 ns; -- Time=105 ns
    reset <= transport '0';
    -- ====================
    WAIT; -- Time=805 us
    -- ====================
  END PROCESS;

END fpga;
