

puts "** Functional (f) or Timing (t) simulation ? "
set data ""
set valid 0 
while {!$valid} {
    gets stdin data
    set valid [expr {($data == f) || ($data == t)}]
    if {!$valid} {
        puts "** Functional (f) or Timing (t) simulation ?)"
        puts "Choose either f or t"
    }
}

if {$data == f} {
    puts "** Run Functional simulation now ..."
} elseif {$data == t} {
    puts "** Run Timing simulation now ..."
}

########## Compile design
set project_name "trisc2" 
vlib work
vlog data_ram.v
vlog {rom4096x18 - dmem.v}
do {tb_ini.do} $data

########## Add I/O signals to wave window
#add wave -divider  "Simulation by UMB"
add wave clk reset
radix -hex
add wave -divider  "Locals:" 
add_one pc_out pc
add_one op_code op6 
add_one ir_imm12 imm12
add_one jc_out jc 
#add_one s0_out {s[0]} 
add_one s1_out {s[1]}
add_one s2_out {s[2]} 
add_one s3_out {s[3]}
add_one z_out z
add_one c_out c
#add wave -label sB {s(11)} 
#add wave -label sD {s(13)}
#add wave -label sE {s(14)}
#add wave -label sF {s(15)}  
#add_one s3_OUT r(3)
#add_one s4_OUT r(4) 
#add_one z_OUT z 
#add_one c_OUT c
#add wave -divider  "Link Stack:" 
#add_local lcount 
#add_local lreg(0) 
#add_local lreg(1) 
#add_local lreg(2) 
add wave -divider  "Data Memory:" 
add_one me_ena mem_ena 
add_local_label {y=idma} y
add_local x
add_local bram/ram(1) 
add_local bram/ram(2) 
#add_local bram/ram(3) 
add_local dmd
add wave -divider  "I/O Ports:"
add wave in_port out_port

######### Add stimuli data
force clk 0 0ns, 1 10ns -r 20ns
force reset 0 0ns, 1 5ns
force in_port 5 0ns

########## Run the simulation
run 400ns
wave zoomfull
configure wave -gridperiod 40ns
configure wave -timelineunits ns
