set project_name "trisc3a" 
puts "** Functional (f) or Timing (t) simulation ? "
set data ""
set valid 0 
while {!$valid} {
    gets stdin data
    set valid [expr {($data == f) || ($data == t)}]
    if {!$valid} {
        puts "** Functional (f) or Timing (t) simulation ?)"
        puts "Choose either f or t"
    }
}

if {$data == f} {
    puts "** Run Functional simulation now ..."
} elseif {$data == t} {
    puts "** Run Timing simulation now ..."
}

########## Compile design
vlib work
vlog {dpram4Kx32 - flash.v}
do {tb_ini.do} $data  

########## Add I/O signals to wave window
#add wave -divider  "Simulation by UMB"
add wave clk reset
radix -hex
add wave -divider  "Locals:" 
add_one pc_out pc
add_local ir
add_local bx
add_one op_code op
add_local pc8
add_local branch_target
add_one ir_imm12 imm12
add_one imm32 imm32_out
add_local dma
add_one jc_out jc 
add_local_uns NN
add_local_uns M
add_local_uns D
add_local Rd
add_local Rn
add_local Rm
add_one {r[1]} r1_out 
add_one {r[2]} r2_out 
add_one {r[3]} r3_out 
add_one {r[4]} r4_out
add_local res
add wave -divider  "I/O Ports:"
add wave in_port out_port

######### Add stimuli data
force clk 0 0ns, 1 10ns -r 20ns
force reset 0 0ns, 1 25ns
force in_port 5 0ns, 5 1000ns 

########## Run the simulation
run 240ns
#run 1010000us
wave zoomfull
configure wave -gridperiod 40ns
configure wave -timelineunits ns
