set project_name "trisc3a" 
puts "** Functional (f) or Timing (t) simulation ? "
set data ""
set valid 0 
while {!$valid} {
    gets stdin data
    set valid [expr {($data == f) || ($data == t)}]
    if {!$valid} {
        puts "** Functional (f) or Timing (t) simulation ?)"
        puts "Choose either f or t"
    }
}

if {$data == f} {
    puts "** Run Functional simulation now ..."
} elseif {$data == t} {
    puts "** Run Timing simulation now ..."
}

########## Compile design
vlib work
vlog {dpram4Kx32 - nesting.v}
do {tb_ini.do} $data 

########## Add I/O signals to wave window
#add wave -divider  "Simulation by UMB"
add wave clk reset
radix -hex
add wave -divider  "Locals:" 
add_one pc_out {pc[11:0]}
add_local ir
add_one op_code op
add_local push
add_local pop
add_local popPC
add_local ind
add_local branch_target
add_one jc_OUT jc 
add_local_uns NN
add_local_uns M
add_local_uns D
add_local_label {r13=sp} {r(13)}
add_local_label {r14=lr} {r(14)}
add wave -divider  "Data Memory:" 
add_local store
add_local load 
add_local_uns {dma[13:2]}
add wave -divider  "sp region:" 
add_local {/mem/dram[4074]}
add_local {/mem/dram[4073]}
add_local {/mem/dram[4088]} 
add_local {/mem/dram[4087]} 
add_local {/mem/dram[4086]}  
add_local dmd
#add wave -divider  "I/O Ports:"
#add wave in_port out_port

######### Add stimuli data
force clk 0 0ns, 1 10ns -r 20ns
force reset 0 0ns, 1 25ns
force in_port 5 0ns, 5 1000ns 

########## Run the simulation
run 660ns
wave zoomfull
configure wave -gridperiod 40ns
configure wave -timelineunits ns
