set project_name "trisc3mb" 
puts "** Functional (f) or Timing (t) simulation ? "
set data ""
set valid 0 
while {!$valid} {
    gets stdin data
    set valid [expr {($data == f) || ($data == t)}]
    if {!$valid} {
        puts "** Functional (f) or Timing (t) simulation ?)"
        puts "Choose either f or t"
    }
}

if {$data == f} {
    puts "** Run Functional simulation now ..."
} elseif {$data == t} {
    puts "** Run Timing simulation now ..."
}

########## Compile design
set project_name "trisc3mb" 
vlib work
vlog data_ram.v
vlog {rom4096x32 - flash.v}
do {tb_ini.do} $data

########## Add I/O signals to wave window
#add wave -divider  "Simulation by UMB"
add wave clk reset
radix -hex
add wave -divider  "Locals:" 
add_local {pc[24:31]}
add_local ir
add_one op_code op
add_local go
add_local cmp
add_local branch_target
add_one jc_out jc 
add_local A
add_local B
add_local D
add_one {r[1]} r1_out 
add_one {r[2]} r2_out 
add_one {r[3]} r3_out 
add_one {r[4]} r4_out
add_local {r(18)}
add_local_label {r19=sp} {r(19)}
add_local res
add_local store
add_local load
add_local write
add_local read
add_local_uns {dma[18:29]}
add_local {/trisc3mb/bram/ram[1909]}
add_local {/trisc3mb/bram/ram[1910]}
add wave -divider  "I/O Ports:"
add wave in_port out_port

######### Add stimuli data
force clk 0 0ns, 1 10ns -r 20ns
force reset 0 0ns, 1 25ns
force in_port 5 0ns, 5 1000ns 

########## Run the simulation
run 400ns
#run 1060ns
#run 1010000us
wave zoomfull
configure wave -gridperiod 40ns
configure wave -timelineunits ns
