## add a local signal for behavior simulation only
proc add_local {var_name} { 
  if { [catch {add wave $var_name}] > 0 } {
    puts "** Uwe Info: Local Signal $var_name is NOT available in simulation!"
  } else {
    puts "** Uwe Info: Add local variable $var_name in wave window for simulation!"
  }
}

## add a local unsigned signal for behavior simulation only
proc add_local_uns {var_name} { 
  if { [catch {add wave -uns $var_name}] > 0 } {
    puts "** Uwe Info: Local Signal $var_name is NOT available!"
  } else {
    puts "** Uwe Info: Add local unsigned variable $var_name in wave window for simulation!"
  }
}

## add a local signal with label for behavior simulation only
proc add_local_label {var_one var_two} { 
  if { [catch {add wave -label $var_one $var_two}] > 0 } {
    puts "** Uwe Info: Local Signal $var_two is NOT available!"
  } else {
    puts "** Uwe Info: Add local variable $var_two with label in wave window for simulation!"
  }
}

## add one of two local signals for behavior simulation only
proc add_one {var_one var_two} { 
  if { [catch {add wave $var_one}] > 0 } {
    if { [catch {add wave $var_two}] > 0 } {
      puts "** Uwe Info: Local Signals $var_one and $var_two are NOT available!"
  } else {    puts "** Uwe Info: Add local variable $var_two in wave window for simulation!"
  }
  } else {
    puts "** Uwe Info: Add local variable $var_one in wave window for simulation!"
  }
}


if {![file exists work]} {
     vlib work
}

if {[catch { vlog $2.v } ] == 0} { vlog $2.v }
if {[catch { vlog $3.v } ] == 0} { vlog $3.v }

## clear wave window first
if { [catch {delete wave *}] == 0 } {   delete wave * } 

## Read in functional or timing simulation switch
puts "** Functional (0) Timing Simulation (1) "
if { $data == f } {
  puts "** Running the Functional Simulation"
  vlog -reportprogress 300 -work work $project_name.v
  vsim work.${project_name}
} else {
  puts "** Running the Timing Simulation"
  if {![file exists gate_work]} {
  vlib gate_work
  }
  vlog -reportprogress 300 -work work ${project_name}.vo
  vsim +altera -L C:/altera/15.1/modelsim_ase/altera/verilog/cyclonev \
  -L C:/altera/15.1/modelsim_ase/altera/verilog/altera \
-L C:/altera/15.1/modelsim_ase/altera/verilog/cyclonev_hssi \
  -L C:/altera/15.1/modelsim_ase/altera/verilog/altera_mf \
  -L C:/altera/15.1/modelsim_ase/altera/verilog/altera_lnsim \
  -l msim_transcript -gui work.${project_name}
}