puts "** Functional (f) or Timing (t) simulation ? "
set data ""
set valid 0 
while {!$valid} {
    gets stdin data
    set valid [expr {($data == f) || ($data == t)}]
    if {!$valid} {
        puts "** Functional (f) or Timing (t) simulation ?)"
        puts "Choose either f or t"
    }
}

if {$data == f} {
    puts "** Run Functional simulation now ..."
} elseif {$data == t} {
    puts "** Run Timing simulation now ..."
}

########## Compile design
set project_name "trisc3n" 
vlib work
vlog data_ram.v
vlog {rom4096x32 - flash.v}
do {tb_ini.do} $data

########## Add I/O signals to wave window
#add wave -divider  "Simulation by UMB"
add wave clk reset
radix -hex
add wave -divider  "Locals:" 
add_one pc pc_out
add_one op op_code 
add_local opx
add_local branch_target
add_one imm16 ir_imm16
add_one imm32 imm32_out
add_one jc jc_out
add_local A
add_local B
add_local C
add_local rA
add_local rB
add_local rC
add_one {r(1)} r1_out 
add_one {r(2)} r2_out 
add_one {r(3)} r3_out 
add_one {r(4)} r4_out
add_local kflag
add_local res
#add wave -divider  "Link Stack:" #
#add_local lcount 
#add_local lreg(0) 
#add_local lreg(1) 
#add_local lreg(2) 
#add wave -divider  "Data Memory:" 
#add_one me_ena mem_ena 
#add_local scratch_pad_ram/idma
#add_local x
#add_local dram(61) 
#add_local dram(62) 
#add_local dram(63) 
#add_local dmd
add wave -divider  "I/O Ports:"
add wave in_port out_port

######### Add stimuli data
force clk 0 0ns, 1 10ns -r 20ns
force reset 0 0ns, 1 5ns
force in_port 5 0ns

########## Run the simulation
run 240ns
wave zoomfull
configure wave -gridperiod 40ns
configure wave -timelineunits ns
