// ========================================================
// IEEE STD 1364-2001 Verilog file: rom128x16.v 
// Author-EMAIL: Uwe.Meyer-Baese@ieee.org
// ========================================================
// Initialize the ROM with $readmemh. Put the memory 
// contents in the file io.hex.  Without this file,
// this design will not compile. See Verilog 
// LRM 1364-2001 Section 17.2.8 for details on the
// format of this file.
// ========================================================
module rom128x16
  (input  CLK,                       // System clock
   input [6:0] ADDRESS, // Address input
   output[15:0] DATA); // Data output
// ========================================================
// Declare the ROM variable
  reg [15:0] ROM[127:0];

  initial
  begin
    $readmemh("io.hex", ROM);
  end

  assign DATA = ROM[ADDRESS];

endmodule

