########## Compile design
vlib work
vlog  rom128x16.v
vlog  urisc.v 
vsim work.urisc

########## Add I/O signals to wave window
add wave CLK RESET
add wave -divider  "Locals:" 
add wave -hex STATE PC DATA 
add wave -dec RD RS ADDRESS
add wave -dec R(0) R(1) R(2) R(15) 
add wave -dec JUMP MODE DIF
add wave -divider  "I/O Ports:"
add wave -dec IN_PORT OUT_PORT

######### Add stimuli data
radix -hex
force CLK 0 0ns, 1 10ns -r 20ns
force RESET 0 0ns, 1 105ns
force IN_PORT 5 0ns 

########## Run the simulation
run 750ns
wave zoomfull
configure wave -gridperiod 40ns
configure wave -timelineunits ns
