// Set reference time to 1 ns and precision to 1 ps
`timescale 1 ns / 1 ps
// ==========================================================
module trisc2_tb;
// ==========================================================
             
// ==== Signal definition no initial values: ================
  reg  clk;              // System clock
  reg  reset;            // Asynchronous reset
  wire [11:0] pc_out;    // Program counter
  wire [5:0] op_code;  // Operation code
  wire [11:0] ir_imm12;    // Immediate value
  wire  [7:0] s0_out;    // Stack register 0
  wire  [7:0] s1_out;    // Stack register 1
  wire  [7:0] s2_out;    // Stack register 0
  wire  [7:0] s3_out;    // Stack register 1
  wire jc_out;           // Jump condition flag
  wire me_ena;
  wire z_out;           // Jump condition flag
  wire c_out;           // Jump condition flag
  reg [7:0] in_port;      // Input port
  wire [7:0] out_port; // Output port
  
  parameter T = 20; // Simulation tick in ns

// ========== Unit under test instantiation: ================
    trisc2 UUT(
        .clk(clk),
        .reset(reset),
        .in_port(in_port),
        .out_port(out_port)      
/*         .s0_out(s0_out),
        .s1_out(s1_out),
        .s2_out(s2_out),
        .s3_out(s3_out),
        .jc_out(jc_out),
        .me_ena(me_ena),
        .z_out(z_out),
        .c_out(c_out),
        .pc_out(pc_out),
        .ir_imm12(ir_imm12),
        .op_code(op_code) */
        );
    
// ================ Periodic signals: =======================
  initial begin
    clk = 0;
    forever #(T/2) clk = ~clk;
  end

// ================ Add stimuli: ============================
  initial begin
    reset = 1;
    in_port = 5;
    #105; // Time=105 ns
    reset = 0;
    #400; // Time=505 ns
  end

endmodule
