// Set reference time to 1 ns and precision to 1 ps
`timescale 1 ns / 1 ps
// ========================================================
module trisc3a_tb;
// ========================================================
             
// ==== Signal definition no initial values: ==============
  reg  sys_clk;              // System clock
  reg  reset;            // Asynchronous reset
  wire [11:0] pc_out;    // Program counter
  wire [3:0] op_code;    // Operation code
  wire [11:0] ir_imm12;  // Immediate value
  wire [31:0] imm32_out; // Sign extend immediate value
  wire  [31:0] r0_out;    // Register 0
  wire  [31:0] r1_out;    // Register 1
  wire  [31:0] r2_out;    // Register 0
  wire  [31:0] r3_out;    // Register 1
  wire  [31:0] sp_out;    // Register 13 aka stack pointer
  wire  [31:0] lr_out;    // Register 14 aka link register
  wire jc_out;           // Jump condition flag
  wire me_ena;          // Memory enable
  wire i_out;           // immediate flag
  reg [7:0] in_port;    // Input port
  wire [7:0] out_port;  // Output port
  
  parameter T = 20; // Simulation tick in ns

// ========= Unit under test instantiation: ===============
    trisc3a UUT(
        .sys_clk(sys_clk),
        .reset(reset),
        .in_port(in_port),
        .out_port(out_port)
/*         .r0_out(r0_out),
        .r1_out(r1_out),
        .r2_out(r2_out),
        .r3_out(r3_out),
        .sp_out(sp_out),
        .lr_out(lr_out),
        .jc_out(rc_out),
        .me_ena(me_ena),
        .i_out(i_out),
        .pc_out(pc_out),
        .ir_imm12(ir_imm12),
        .imm32_out(imm32_out),
        .op_code(op_code) */
        );
    
// =============== Periodic signals: ======================
  initial begin
    sys_clk = 0;
    forever #(T/2) sys_clk = ~sys_clk;
  end

// =============== Add stimuli: ===========================
  initial begin
    reset = 1;
    in_port = 5;
    #105; // Time=105 ns
    reset = 0;
    #400; // Time=505 ns
  end

endmodule
