// Set reference time to 1 ns and precision to 1 ps
`timescale 1 ns / 1 ps
// ========================================================
module trisc3mb_tb;
// ========================================================
             
// ==== Signal definition no initial values: ==============
  reg  sys_clk;              // System clock
  reg  reset;            // Asynchronous reset
  wire [0:11] pc_out;    // Program counter
  wire [0:5] op_code;    // Operation code
  wire [0:15] ir_imm16;  // Immediate value
  wire [0:31] imm32_out; // Sign extend immediate value
  wire  [0:31] r1_out;    // Register 1
  wire  [0:31] r2_out;    // Register 2
  wire  [0:31] r3_out;    // Register 3
  wire  [0:31] r19_out;    // Register 19 aka stack pointer
  wire  [0:31] r15_out;    // Register 15 aka link register
  wire jc_out;           // Jump condition flag
  wire me_ena;          // Memory enable
  wire i_out;           // immediate flag
  reg [7:0] in_port;    // Input port
  wire [7:0] out_port;  // Output port
  
  parameter T = 20; // Simulation tick in ns

// ============ Unit under test instantiation: ============
    trisc3mb UUT(
        .sys_clk(sys_clk),
        .reset(reset),
        .in_port(in_port),
        .out_port(out_port)
/*         .r1_out(r1_out),
        .r2_out(r2_out),
        .r3_out(r3_out),
        .r19_out(r19_out),
        .r15_out(r15_out),
        .jc_out(rc_out),
        .me_ena(me_ena),
        .i_out(i_out),
        .pc_out(pc_out),
        .ir_imm16(ir_imm16),
        .imm32_out(imm32_out),
        .op_code(op_code) */
        );
    
// ============ Periodic signals: =========================
  initial begin
    sys_clk = 0;
    forever #(T/2) sys_clk = ~sys_clk;
  end

// ============ Add stimuli: ==============================
  initial begin
    reset = 1;
    in_port = 5;
    #105; // Time=105 ns
    reset = 0;
    #400; // Time=505 ns
  end

endmodule
