// Set reference time to 1 ns and precision to 1 ps
`timescale 1 ns / 1 ps
// ========================================================
module trisc3n_tb;
// ========================================================
             
// ========= Signal definition no initial values: =========
  reg  clk;              // System clock
  reg  reset;            // Asynchronous reset
  
  wire [11:0] pc_out;    // Program counter
  wire [5:0] op_code;    // Operation code
  wire [15:0] ir_imm16;  // Immediate value
  wire [31:0] imm32_out; // Sign extend immediate value
  wire jc_out;           // Jump condition flag
  wire k_out;            // immediate flag  
  wire  [31:0] r0_out;   // Register 0
  wire  [31:0] r1_out;   // Register 1
  wire  [31:0] r2_out;   // Register 0
  wire  [31:0] r3_out;   // Register 1
  wire  [31:0] sp_out;   // Register 13 aka stack pointer
  wire  [31:0] lr_out;   // Register 14 aka link register
  wire me_ena;           // Memory enable

  reg [7:0] in_port;     // Input port
  wire [7:0] out_port;   // Output port
  
  parameter T = 20; // Simulation tick in ns

// ========= Unit under test instantiation: =========
    trisc3n UUT(
        .clk(clk),
        .reset(reset),
        .in_port(in_port),
        .out_port(out_port)
/*       
        .pc_out(pc_out),
        .op_code(op_code),		
        .ir_imm16(ir_imm16), 
        .imm32_out(imm32_out),
        .jc_out(rc_out),
		.k_out(k_out),
        .r1_out(r1_out),
        .r2_out(r2_out),
        .r3_out(r3_out),
        .r4_out(r4_out),		
        .sp_out(sp_out),
        .ra_out(ra_out),
        .me_ena(me_ena), */
        );
    
// ========= Periodic signals: ============================
  initial begin
    clk = 0;
    forever #(T/2) clk = ~clk;
  end

// ================== Add stimuli: ========================
  initial begin
    reset = 1;
    in_port = 5;
    #105; // Time=105 ns
    reset = 0;
    #400; // Time=505 ns
  end

endmodule
