## add a local signal for behavior simulation only
proc add_local_hex {var_name} { 
  if { [catch {add wave -hex $var_name}] > 0 } {
    puts "** Uwe Info: Local Signal $var_name is NOT available!"
  } else {
    puts "** Uwe Info: Add local hex variable $var_name in wave window for simulation!"
  }
}

## add a local unsigned signal for behavior simulation only
proc add_local_uns {var_name} { 
  if { [catch {add wave -uns $var_name}] > 0 } {
    puts "** Uwe Info: Local Signal $var_name is NOT available!"
  } else {
    puts "** Uwe Info: Add local unsigned variable $var_name in wave window for simulation!"
  }
}

## add a local unsigned signal for behavior simulation only
proc add_local_dec {var_name} { 
  if { [catch {add wave -dec $var_name}] > 0 } {
    puts "** Uwe Info: Local Signal $var_name is NOT available!"
  } else {
    puts "** Uwe Info: Add local signed variable $var_name in wave window for simulation!"
  }
}

########## Compile design
puts "** Functional Simulation"
vlib work
vlog rom128x16.v
vlog urisc.v
vlog urisc_tb.v
vsim work.urisc_tb

########## Add I/O signals to wave window
add wave clk reset

radix -hex
add wave -divider  "Locals:" 
add_local_hex UUT/state 
add_local_hex UUT/pc 
add_local_hex UUT/data 
add_local_uns UUT/rd 
add_local_uns UUT/rs 
add_local_uns UUT/address
add_local_dec UUT/r(0) 
add_local_dec UUT/r(1) 
add_local_dec UUT/r(2) 
add_local_dec UUT/r(15) 
add_local_dec UUT/jump 
add_local_dec UUT/mode 
add_local_dec UUT/dif

add wave -divider  "I/O Ports:"
add wave -dec in_port out_port

######### Add stimuli data in HDL code => see HDL code
#force clk 0 0ns, 1 10ns -r 20ns
#force reset 1 0ns, 0 5ns
#force iport 3 0ns

########## Run the simulation
run 750ns
wave zoomfull
configure wave -gridperiod 40ns
configure wave -timelineunits ns
