function [U,u,X,Y] = adv_diff(eps,p,q,M,upwind);
%ADV_DIFF generates advection-diffusion problem solution
%   Essential PDES function: DJS; 30 June 2015.

% This function is called by the file
%       advdiff_driver
% to generate data for Examples 10.16 and 10.17 from
%     Essential PDEs, Griffiths, Dold & Silvester

% compute FD solution for 2D advection-diffusion  BVP
% 
%       -eps(u_xx+u_yy)+pu_x+qu_y=0
% with the Dirichlet BCs:
%       u = 0 on y = 0,1 and x = 1;
%       u = sin(n.pi.y)  on x = 0
% The parameter "upwind" controls the type of FD aproximation
% upwind = 0:  central differences 
%        = 1: upwinding
% Output:
%   U: numerical solution
%   u: exact solution
%   X,Y: grid coordinates
h = 1/M;
Px = .5*p*h/eps;  Py = .5*q*h/eps;     %Peclet numbers
esx = eps*M^2; esy = esx;  % scaled diffusion coefficients
% modify diffusion coeffs for upwind method
if upwind>0
    esx = esx*(1+abs(Px));esy = esy*(1+abs(Py)); 
end
ps = .5*p*M; qs = .5*q*M; % scaled coefficients
e = ones(M-1,1);
% ay.U is a matrix representation of -eps.u_yy + q.u_y
ay = spdiags([-e*(esy+qs) 2*esy*e -e*(esy-qs)],-1:1,M-1,M-1);
% ax.U is a matrix representation of -eps.u_xx + p.u_x
ax = spdiags([-e*(esx+ps) 2*esx*e -e*(esx-ps)],-1:1,M-1,M-1);
id = speye(M-1);
A = kron(id,ay)+kron(ax,id);
f = zeros((M-1)^2,1);
y = (1:M-1)'*h;
v = sin(pi*y);
f(1:M-1) =(esx+ps)*v;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Solve and locate solution in a 2D array %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

tmp = A\f; 
    U = zeros(M+1,M+1); 
    U(2:end-1,2:end-1) = reshape(tmp,M-1,M-1);
    [u,X,Y] = advdiff_exact(eps,1,0,M);
    U(:,1)=u(:,1); % apply BC at x=0
    