%ADVDIFF_DRIVER driver for advection-diffusion equation in square domain
%   Essential PDES scriptfile: DFG; 30 June 2015.

% File: advdiff_driver
% Example 10.17
% Solves
%   -eps(u_xx+u_yy)+pu_x+qu_y=0
% with the Dirichlet BCs
%   u = 0 on y = 0, 1 and x = 1;
%   u = sin(pi.y)      on x = 0.
% and draws Fig. 10.17

fntsz = 30;  % fontsize
figure(1)
% calculate & plot exact solution 
[u,X,Y,M,eps] = advdiff_exact();  % Use default parameter values
    mesh(X,Y,u)
    view(40,40)
    xlabel('$x$')
    ylabel('$y$')
    colormap([0 0 0])
    printfig('adv_diff_exact',1);
figure(2)
    uc = u(9,:); % Exact solution on y=1/2
    xc = X(9,:); % x- grid lines
    plot(xc,uc,'-'), hold on
    xlabel('$x$')
    sty = ['.--';'x--']; % plot styles

for upwind = 0:1 
    [U,u,X,Y] = adv_diff(eps,1,0,M,upwind);
%     [A,f] = adv_diff_mat(eps,1,0,M,upwind);
%     tmp = A\f; 
%     U = zeros(M+1,M+1); 
%     U(2:end-1,2:end-1) = reshape(tmp,M-1,M-1);
%     [u,X,Y] = advdiff_ex(eps,1,0,1,M);
%     U(:,1)=u(:,1); % apply BC at x=0
    plot(X(M/2+1,:),U(M/2+1,:),sty(1+upwind,:))
end
axis([0 1 0 1.1])
xlabel('$x$','fontsi',fntsz)
mvxlabel(2,[.7,-.08]);
printfig('adv_diff-cl',2);
