%ADVDIFF_ERROR generates figure 10.18
%   Essential PDES scriptfile: DFG; 30 June 2015.

% Example 10.17, part 2
% Solves
%   -eps(u_xx+u_yy)+pu_x+qu_y=0
% with the Dirichlet BCs
%   u = 0 on y = 0, 1 and x = 1;
%   u = sin(pi.y)      on x = 0.
% and draws figure 10.18

%%%%%%%%%%% Fig 10.17
setdefaults
fntsz = 24;  % fontsize

MM = 3:11;
fprintf('Grid level \n')
fprintf(' %g..',MM)
H  = 1./2.^MM;     % grid sizes used
Lm = length(MM);
file = 'adv_diff_2'; 
EPS   = zeros(3,2);  %  used for placing text
for k = 1:3
    eps =10^(-k);
    for upwind = [0,1]
        err = zeros(1,Lm);   % save max errors
          for j = 1:Lm
            M=2^MM(j);
            [U,u,X,Y] = adv_diff(eps,1,0,M,upwind);
            err(j) = norm(U(:)-u(:),inf);
            if M==32 & k==2
                figure(3+10*(1+upwind))
                mesh(X,Y,u)
                figure(2+10*(1+upwind))
                mesh(X,Y,U)
            end
        end
        figure(20+upwind) 
        kp = find(H/(2*eps)<=1);  % find data points with Pe_h<=1
        loglog(H,err,'.--',H(kp),err(kp),'ro-')
        hold on  
        EPS(k,upwind+1) = err(end);
    end   
end
hold off
fprintf('\n')
figure(20)
    ax=axis; ax(3:4) = [1e-7,1]; axis(ax);
    xlabel('$h$','fontsi',fntsz)
    for k = 1:3
        text(H(end)/2,EPS(k,1),['$\varepsilon=10^{-' int2str(k) '}$'],'rot',45) %4-k
    %    text(g20(k,1),g20(k,2),['$\varepsilon=10^{-' int2str(4-k) '}$'],'rot',45)
    end
figure(21)
    xlabel('$h$','fontsi',fntsz)
    axis(ax)
    angle = atan(.5)*180/pi;
    for k = 1:3
        text(H(end)/2,EPS(k,2),['$\varepsilon=10^{-' int2str(k) '}$'],'rot',angle)
    %    text(g21(k,1),g21(k,2),['$\varepsilon=10^{-' int2str(4-k) '}$'],'rot',angle)
    end
printfig('adv_diff_2',20:21)
