function [u,X,Y,M,eps] = advdiff_exact(eps,p,q,X,Y)
%ADVDIFF_EXACT generates exact advection-diffusion problem solution
%   Essential PDES function: DJS; 30 June 2015.

% Exact solution of 
%   -eps(u_xx+u_yy)+pu_x+qu_y=0
% with the Dirichlet BCs
%   u = 0 on y = 0, 1 and x = 1;
%   u = sin(pi.y)      on x = 0.
% Default parameters are used if there are no input arguments
% Similar to Figure 10.17 of
% Essential PDEs by Griffiths, Dold & Silvester
if nargin<1
    p = 1;
    q = 0;
    eps = .02;
    M = 16;
    y = (0:M)/M;
    % Pack boundary layer with extra grid lines graded exponentially
    P=(1:M-1)/M;
    x = sort([ 0 .25 .5 .75 (1+2*eps*log(1-P)) 1]);
        [X,Y] = meshgrid(x,y);
elseif nargin==4
    M=X;
    x = (0:M)/M; 
    [X,Y] = meshgrid(x);
end

e2 = 2*eps;
gamma = sqrt(p^2+q^2+(e2*pi)^2)/e2;
if gamma<16
    u = exp((p*(X)+q*(Y))/e2).*(sinh(gamma*(1-X))/sinh(gamma)).*sin(pi*Y);
else
    % Use the asymptotic approximation (10.48) if gamma is too large
    u = exp(((p-e2*gamma)*(X)+q*(Y))/e2).*(1-exp(-2*gamma*(1-X))).*sin(pi*Y);
end

