%CIRCLE_DRIVER driver for the Poisson equation in a circular domain
%   Essential PDES scriptfile: DFG; 30 June 2015.

% File: circle_driver
% Examples 10.7 & 10.12
% Calls circle_cartesian.m for Cartesian Coordinates
%       circle_polar.m for Polar Coordinates

MM = (4:7)';          % 2^MM grid points in each direction
Lm = length(MM);
errors = zeros(Lm,2); % Max errors, 
                      % 1st column cartesian, 2nd polar
T = errors;     % save timings
Tp = T;         % polar coords timings
for j = 1:Lm
    M = 2^MM(j);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Cartesian
    [U,Ex,X,Y,t] = circle_cartesian(M,M==16); % plot results & save if M=16
    T(j,:) = t;
    cn = isnan(U);     % find the nans in numerical solution
    ck = find(cn==0);  % non-nan indices
    errors(j,1)=max(max(abs(Ex(ck)-U(ck))));
    fprintf('Max error with M = %g is %g\n',M,errors(j,1) );
    fprintf('Timings: Setup = %g,  Solve = %g (%5.2f %%)\n',T,T(2)/T(1));
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Polar
    [Up,Ep,tp] = circle_polar(M,M==16); %
    errors(j,2)=max(max(abs(Ep-Up)));
    Tp(j,:) = tp;
end
ratio = [zeros(1,2);errors(1:end-1,:)./errors(2:end,:)];
% display results in Latex tabular format - Table 10.4
disp('   M   Error        ratio      cpu      %')
fprintf('%4i & %8.7f &  %5.2f &  %7.4f & %4.1f\\\\\n',...
    [2.^MM  errors(:,1) ratio(:,1) sum(T')' T(:,1)./T(:,2)*100]')

% display results in Latex tabular format - Table 10.5
disp('   M       Square grid         Polar grid')
fprintf('%4i & %8.7f &  %5.2f &  %8.7f &  %5.2f\\\\\n',...
    [2.^MM  errors(:,1) ratio(:,1)  errors(:,2) ratio(:,2) ]')
