function [G,E,est,X,Y,times] = poisson_est(M)
%POISSON_EST generates data in Example 10.6
%   Essential PDES function: DFG; 30 June 2015.

% This function is called by the file
%       poisson_post
% Example 10.6 from  Essential PDEs, Griffiths, Dold & Silvester
% 
% Solve Poisson's equation on the unit square 
% Lu = f(x,y) in R
%  u = g(x,y) on boundary
% f is defined by the function rhs(x,y), see below
% g is defined by the function bv(x,y), see below
% Output:
%   G: the numerical solution 
%   E: the exact solution
%   est: an estimate of the global error
%   X,Y: coordinates of grid points
%   times: a 1x3 array containing timings of
%          a) factorization; b) solve & c) error estimation
h = 1/M;
% Define the grid points
[X,Y] = meshgrid((0:M)/M);
% internal grid points
x = X(2:end-1,2:end-1);
y = Y(2:end-1,2:end-1);
% build matrix A
e = ones(M-1,1);
D = spdiags(e*[-1, 2, -1],-1:1,M-1,M-1);
I = speye(M-1);
A = kron(D,I)+kron(I,D);
% forcing term
f = rhs(x,y); fcopy = f; % save until later
f = f(:);                % convert to a column vector
% BCs
G = bv(X,Y,M);          % all the boundary values
E = G;                  % exact solution
g = zeros((M-1)^2,1);   % required vector of BVs
% left 
g(1:M-1) = G(2:M,1);
% right 
g((M-1)^2-M+2:(M-1)^2) = G(2:M,M+1);
% bottom 
g(1:M-1:(M-1)^2) = g(1:M-1:(M-1)^2) + G(1,2:M)';
% top
g(M-1:M-1:(M-1)^2) = g(M-1:M-1:(M-1)^2) +G(M+1,2:M)';
% Factorize A
tic
[L,R] = lu(A);
times(1) = toc;
% solve

tic
U = R\(L\(h^2*f + g));
times(2)=toc;
U = reshape(U,M-1,M-1);
G(2:M,2:M)=U;

tic
% Now estimate the error
F = rhs(X,Y);   % need values of rhs
                % on the boundary

fb = zeros((M-1)^2,1);   % required vector of BVs
% left 
fb(1:M-1) = F(2:M,1); % reuse stored f-values
% right 
fb((M-1)^2-M+2:(M-1)^2) = F(2:M,M+1);
% bottom 
fb(1:M-1:(M-1)^2) = fb(1:M-1:(M-1)^2) + F(1,2:M)';
% top
fb(M-1:M-1:(M-1)^2) = fb(M-1:M-1:(M-1)^2) +F(M+1,2:M)';
D = spdiags(e*[-1, 2, -1],0:2,M-1,M+1);
f = (1/6)*(D*G*D');  % calculates U_xxyy
tmp = R\(L\(f(:)+ (h^2/12)*fb(:)));
est = zeros(size(X));
est(2:end-1,2:end-1)= reshape(tmp,M-1,M-1)-(h^2/12)*fcopy;
times(3) = toc;
%%%%%%%%%%%%%
function f = rhs(x,y)
a =5/4; b =5/4;
f =4*(2*x.*y-b*x-a*y)./((x-a).^2+(y-b).^2);
function G = bv(X,Y,M)
% the exact solution
a =5/4; b =5/4;
G = -X.*Y.*log((X-a).^2+(Y-b).^2);

    
    