%POISSON_POST generates table 10.3
%   Essential PDES scriptfile: DFG; 30 June 2015.

% File: poisson_post.m
% Example 10.17 of Essential PDEs by Griffiths, Dold & Silvester
%
% Runs the file poisson_est.m with grids of different sizes
% and post-processes the numerical solutions to produce the
% results in Table 10.3
MM = 2+(0:6);
setdefaults
% Initialize arrays
Lm = length(MM);  % Number of grids
H = 1./2.^MM;      % grid sizes
errors = zeros(Lm,3);        % max errors
T = errors;       % save timings

for j = 1:Lm
    M = 2^MM(j);
    % the function poisson_est also returns an estimate "est"
    % of the global error
    [U,Ex,est,X,Y,times] = poisson_est(M);
    errors(j,1) = max(max(abs(Ex-U)));
    errors(j,2) = max(max(abs(est)));
    errors(j,3) = max(max(abs(Ex-U-est)));

    if M==32
      figure(1)
        mesh(X,Y,U);
        set(gca,'fontsi',20,'ytick',0:.5:1), axis tight, view([-70,35])
        colormap([0 0 0])
        title('Numerical solution with M=32')
      figure(2)
        mesh(X,Y,Ex-U);view([-70,35])
        colormap([0 0 0])
        set(gca,'fontsi',20)
        title('Global error with M=32')
      figure(3)
        mesh(X,Y,est);view([-70,35])
        colormap([0 0 0])
        set(gca,'fontsi',20)
        title('Estimated error with M=32')
    end
  T(j,:) = times;
end
% Process solutions
ratio = [zeros(1,3);errors(1:end-1,:)./errors(2:end,:)];

% display results in Latex tabular format - Table 10.3
disp('   M       E           Ehat       u-U-Ehat   ratio  ')
fprintf('%4i & %8.7f &  %8.7f &  %10.9f & %5.2f \\\\\n',...
    [2.^MM'  errors ratio(:,3)]')

figure(4)
loglog(H,errors,'.-')
text(.75*H(2),errors(2,1),'Original Errors','Horiz','right')
text(1.5*H(Lm-1),errors(Lm-1,3),'Errors in extrapolated solution')
xlabel('$h$')
figure(5)
h = H(3:end); t = T(3:end,:); tmean = sum(t(1,:))/3;
loglog(H,T,'.-',h,tmean*(h(1)./h).^3,'--')
title('Timings')
xlabel('$h$')
disp('Dashed line has gradient -3')

