%RICHARDSON generates table 10.2
%   Essential PDES scriptfile: DFG; 30 June 2015.

% File: richardson.m
% Example 10.5 of Essential PDEs by Griffiths, Dold & Silvester
%
% Runs the file poisson.m with grids of different sizes
% to produce the results for Richardson extrapolation in Table 10.2
MM = 2+(0:4);
setdefaults
% Initialize arrays
Lm = length(MM);  % Number of grids
H = zeros(Lm,1);  % grid sizes
error = H;        % max errors
errorP = H;       % error at (.75,.75)
Q = H;            % array to save the numerical solution at (.75,.75)
                  % for each grid
prnt = 0;         % don't print coeff matrix pattern unless prnt>0
%%%%%%%%%%%%%%%%%%%%%%%%% Loop over grids
for j = 1:length(MM)
    M = 2^MM(j);
    [U,Ex,X,Y,times] = poisson(M,prnt); 
    m = 1+3*M/4;  % index of target point (.75,.75)
    Q(j) = U(m,m);
    H(j) = 1/M;
    
  error(j) = max(max(abs(Ex-U))); 
  errorP(j) = abs(Ex(m,m)-U(m,m));
end
%%%%%%%%% process results 
d = diff(Q);
p = log(abs(d(1:end-1)./d(2:end)))/log(2);   % EOC
Q0 = (2.^p.*Q(3:end)-Q(2:end-1))./(2.^p-1);  % estimated limit

eP = [0;0;Q0]-[0;0;Q(3:end)];       %Q(0) - Q(h)
ee = [Q0]-Ex(m,m);              % error in extrapolated solution
% display results in Latex tabular format - Table 10.2
disp('   M    Q(h)         E(h)         EOC      Q(0)    Q(0)-Q(h)')
fprintf('%4i & %7.5f &  %8.7f &  %6.3f & %7.5f  &  %8.7f\\\\\n',...
    [1./H  Q errorP  [0;0;p]  [0;0;Q0] eP]')

figure(1)
loglog(H,abs(Q-Ex(m,m)),'.-',H(3:end),abs(Q0-Ex(m,m)),'.--')
text(.75*H(2),error(2),'Original Errors','Horiz','right')
text(1.25*H(Lm-1),ee(2),'Errors in extrapolated solution')
xlabel('$h$')


