%SQUARE_DRIVER driver for Poisson equation in unit square domain
%   Essential PDES scriptfile: DFG; 30 June 2015.

% Example 10.1 of Essential PDEs by Griffiths, Dold & Silvester
% Runs the file poisson.m with grids of different sizes
% to produce the results in Figs 10.3 & 10.4 and Table 10.1
MM = 2+(1:6);
setdefaults
% Initialize arrays
Lm = length(MM);  % Number of grids
T = zeros(Lm,2);  % save times
H = zeros(Lm,1);  % grid sizes
error = H;        % errors

file = 'poisson';
%%%%%%%%%%%%%%%%%%%%%%%%% Loop over grids
for j = 1:length(MM)
    M = 2^MM(j);
    [U,E,X,Y,times] = poisson(M);
    x = X(2:end,2:end); y = Y(2:end,2:end);
    H(j) = 1/M;
    if M<64 % plot solutions on coarsest grids
      figure(2*j-1)
      mesh(X,Y,U);
        set(gca,'fontsi',20), axis tight, view([-70,35])
        colormap([0 0 0])
        ax = axis;
        axis(ax);
        set(gca,'ytick',0:.5:1)
        printfig(file,2*j-1,M==16) % save figure if M=16
      figure(2*j)
      mesh(X,Y,E-U);view([-70,35])
        colormap([0 0 0])
        set(gca,'fontsi',20)
        printfig(file,2*j,M==16)
    end
  error(j) = max(max(abs(E-U))); 
  T(j,:) = times;
end
ratio = [0; error(1:end-1)./error(2:end)];
%%%%%%%%% process results 

% display results in Latex tabular format - Table 10.1
disp('   M   Error        ratio     cpu      %')
fprintf('%4i & %8.7f &  %5.2f &  %7.4f %4.1f\\\\\n',...
    [1./H  error ratio sum(T')' T(:,2)./T(:,1)*100]')

figure(30)
    loglog(H,T,'.-')
    title('Timings vs h')
    Hm = H(4);
    Tm =  exp(.5*(log(T(4,1))+log(T(4,2))));
    hold on
    loglog(Hm*[1 1/8],Tm*[1 8].^3,'--')
    disp('figure(30): Dashed line has gradient -3, Time proportional to M^3')
figure(10)
    loglog(H,error,'.-')
    title('loglog error vs h')
