%CRANK_NICOLSON generates table 11.3
%   Essential PDES scriptfile: DJS; 30 June 2015.

% Example 11.15 of Essential PDEs by Griffiths, Dold & Silvester
% Crank-Nicolson solution of the heat equation on 0<x<1 with
% BCs u(0,t) = u(1,t) = 0 
% IC  u(x,0) = sin(pi*x).
% Uses M = 20, 40 & 80, and r =  5 & k = h to
% produce the results in Table 11.3.
%

% Define the exact solution as a function of x & t
exact = @(x,t) exp(-pi^2*t).*sin(pi*x);
MM = [20 40 80];
Tf = .2;        % final time
errorcn = zeros(3,2); % array for storing max errors for C-N
errorbt = zeros(3,2); % array for storing max errors for BTCS
NN = errorcn;         % array for storing number of time steps N
for i = 1:3     % Loop over M-values
    M = MM(i);
    h = 1/M;
    x = h:h:1-h;    % internal grid points
    for j = 1:2
        if j==1
            r = 5;
        else
            r = M;
        end
        k = r*h^2;
        r1 = 1-r; r2 = r/2; % coefficients
    % construct BTCS coefficient matrix
        e = ones(M-1,1);
        Ab = spdiags(e*[-r (1+2*r) -r],-1:1,M-1,M-1);
        Rb = chol(Ab);    % upper triangular factor in Cholesky factorization
    % construct C-N coefficient matrix
        Ac = spdiags(e*[-r2 (1+r) -r2],-1:1,M-1,M-1);
        Rc = chol(Ac);    % upper triangular factor in Cholesky factorization        
        N = ceil(Tf/k);   % number of time steps
        NN(i,j) = N;
        Ub = exact(x',0);  % initial condition (column vector)
        Uc = Ub;
      for n = 1:N
        t = n*k;
        Uc = [0; Uc; 0];   % include boundary values
        Uc = Rc\(Rc'\(r2*(Uc(1:M-1)+Uc(3:M+1))+r1*Uc(2:M))); 
        % Uc no longer contains boundary values
        Ub = Rb\(Rb'\Ub);
      end
      ex = exact(x',t);
      errorcn(i,j) = norm(ex-Uc,inf); % BTCS errors
      errorbt(i,j) = norm(ex-Ub,inf); % C-N errors
    end
end
ratio   = errorcn(1:end-1,:)./errorcn(2:end,:);
ratiobt = errorbt(1:end-1,:)./errorbt(2:end,:);
fprintf('                  r = 5                                  r = h\n')
fprintf('                 Max Error                             Max Error\n')
fprintf('  h      N     BTCS       C-N    ratio  |    N    BTCS   ratio    C-N    ratio\n')
fprintf('1/%2i   %4i  %6.4f   %9.6f  %5.2f  | %4i  %6.3f  %5.2f  %7.5f  %5.2f\n',...
    [MM' NN(:,1)  errorbt(:,1) errorcn(:,1) [0;ratio(:,1)] NN(:,2) errorbt(:,2)  [0;ratiobt(:,2)]   errorcn(:,2)  [0;ratio(:,2)] ]')

