%MOL_FIG generates figure 11.9
%   Essential PDES scriptfile: DJS; 30 June 2015.

% File: mol.m
% Example 11.27  of Essential PDEs by Griffiths, Dold & Silvester
%
% Method of Lines for heat equation on 0<x<1
% with 
%     Neumann BC u_x(0,t) = 0 
%   & Dirichlet BC u(1,t) = sin(2*pi*t)
% and IC u(x,0) = 0.

M = 10;
h = 1/M;
x = (0:M)/M;
U0 =zeros(M,1);    % initial condition
options = odeset('stats','on','AbsTol',1e-6,'RelTol',1e-3);
%-------------------- solves the odes dU/dt = heat1d
[t,U] = ode15s(@heat1d,[0,5],U0,options);
%--------------------
figure(1)
subplot(3,1,1:2)
V = [U sin(2*pi*t)]; % append the Dirichlet BC to U
[X,T]=meshgrid(x,t);
waterfall(T',X',V')
colormap([0 0 0])
axis tight
ylabel('$x$','fontsize',24),xlabel('$t$','fontsize',24)
printfig('mol1d',1)
