%FTCS generates table 11.1
%   Essential PDES scriptfile: DJS; 30 June 2015.

% Example 11.1 of Essential PDEs
% by Griffiths, Dold & Silvester
% File: ftcs_a.m
% FTCS solution of the heat equation on 0<x<1 with
% BCs u(0,t) = u(1,t) = 0 
% IC  u(x,0) = sin(pi*x).
% Uses M = 20, 40 & 80, and r = 0.5 & 0.52 to
% produce the results in Table 11.1
%

% Define the exact solution as a function of x & t
exact = @(x,t) exp(-pi^2*t).*sin(pi*x);
MM = [20 40 80];
R = [0.5 0.52]; % the two values of the mesh ration r =h/h^2
Tf = .2;        % final time
errors = zeros(3,2); % array for storing max errors
NN = errors;         % array for storing number of time steps N
for i = 1:3     % Loop over M-values
    M = MM(i);
    h = 1/M;
    x = h:h:1-h;    % internal grid points
    for j = 1:2
        r = R(j);
        r2 = 1-2*r; % calculate this coefficient only once
                    % and not at each time step
        k = r*h^2;
        N = ceil(Tf/k);  % number of time steps
        NN(i,j) = N;
        U = exact(x,0);  % initial condition
      for n = 1:N
        t = n*k;
        U = [0 U 0];   % include boundary values
        U = r*(U(1:M-1)+U(3:M+1))+r2*U(2:M); 
        % U no longer contains boundary values
      end
    ex = exact(x,t);
    errors(i,j) = norm(ex-U,inf);
    end
end
ratio = errors(1:end-1,:)./errors(2:end,:);
fprintf('            r = %4.2f              r = %4.2f\n',R)
fprintf('  h      N   Max Error    ratio      N   Max Error\n')
fprintf('1/%2i   %4i  %9.6f    %5.2f    %4i  %6.2g\n',...
    [MM' NN(:,1)  errors(:,1) [0;ratio(:,1)] NN(:,2)  errors(:,2)]')