%HYP_BC_FIG generates figure 12.16
%   Essential PDES scriptfile: DJS; 30 June 2015.

% Example 12.17 of Essential PDEs by Griffiths, Dold & Silvester
% Problem: The advection equation
%       u_t + u_x =0, 0<x<1, 0 < t<=0.45
% with exact solution u(x,t) = (x-t)^2. 
% The BC for u(0,t) and IC for u(x,0) are taken from the exact solution.
% Two methods are used:
% a) Lax-Wendroff and (b) leapfrog
% with outflow BC at x=1 supplied by FTBS.
% Parameters used:
%   Courant number c = 0.45
%   M = 16

exact = @(x,t) (x-t).^2;    % the exact solution
Tend = .45;
c    = .45;
M    = 16; h = 1/M;
k = c*h;   % time step
    x = (0:h:1)';
    N = ceil(Tend/k); % Number of time steps
% Lax-Wendroff-coefficients
     cl = c*(1+c)/2; 
     cc = 1-c^2;
     cr = c*(c-1)/2;
    U = zeros(M+1,N+1); % Array to store L-W solution
    V = U;              % Array to save leapfrog solution
    [X,T] = meshgrid(x,(0:N)*k);
    Ex = exact(X,T);
    U=Ex';
    e = ones(M,1);
    % Set up L-W as U(n+1) = A*U(n) + BC terms
    A = spdiags(e*[cl cc cr],-1:1,M,M);
    A(M,M-1:M) = [c 1-c]; % adjust last row for FTBS BC at x=1
    
    % Set up leapfrog as V(n+1) = B*V(n) +V(n-1) + BC terms
    B = spdiags(e*[c  -c],[-1,1],M,M);
    B(M,M-1:M) = [c 1-c]; % adjust last row for FTBS BC at x=1
    for j = 1:N
        U(2:end,j+1) = A*U(2:end,j)+[cl*U(1,j);zeros(M-1,1)];
        if j==1
            V = U;  % leapfrog uses Lax-Wendroff at step 1
        else
            V(2:end,j+1) = B*V(2:end,j)+[c*V(1,j);zeros(M-1,1)]...
                + [V(2:end-1,j-1);0];
        end         
    end
    error = Ex-U;
  figure(1),  
    mesh(X,T,(U'))
    colormap([0 0 0])
    view([-45,45])
    axis tight
  figure(2)
  subplot(3,1,1:2)
    error =Ex-U';
    mesh(X,T,error)
    view(-20,40)
    set(gca,'ytick',[0:Tend/2:Tend])
    axis([0 1 0 .45 [-2 2]*1e-3])
    colormap([0 0 0])
    xlabel('$x$'),ylabel('$t$')
  figure(3)
  subplot(3,1,1:2)
    errorV =Ex-V';
    mesh(X,T,errorV)
    view(-20,40)
    set(gca,'ytick',[0:Tend/2:Tend])
    axis([0 1 0 .45 [-2 2]*1e-3])
    colormap([0 0 0])
    xlabel('$x$'),ylabel('$t$')
