function [u,x] = hyp_ic(M);
%HYP_IC  defines initial condition for hyperbolic tests
%   Essential PDES function: DJS; 30 June 2015.

% Leonard - style initial condition for hyperbolic tests
% h = 3/M
% M should be an even multiple of 10

x=(0:M)*3/M;				% computational grid
h = 3/M;

Z = zeros(size(x));
u = ((x>1/4&x<3/4) +.5*(x==.25)+.5*(x==.75))...	% square wave		% square wave
    + max([1-4*abs(x-1.5); Z])...		% triangle
    + cos(2*pi*x).^2.*(x>=2.25 & x<=2.75);% cosine wave

% end of initial condition
 
