%HYP_LIMITER_FIG generates figure 12.18
%   Essential PDES scriptfile: DJS; 30 June 2015.

% Example 12.18 of Essential PDEs by Griffiths, Dold & Silvester
% Use the van Leer limiter to to produce the results in Fig. 12.18

plt = 0; % plot solution on coarse grid at every time step if plt ~=0
a = 1;   % characteristic speed
M = 60;  % basic grid size h = 1/M
L = 3;   % length of domain
T = 3;   % final time
c = 0.45;				 %  Courant number fixed
cg = 0.5*c*(1-c);
for i = 1:2
    h = 1/(i^2*M);
    k = h*c/a;			 %  time step 
    [u,x0] = hyp_ic(L*M*i^2);	 %  Initial data
    u = u(:);          % column vector
    u0 = u;            % save IC
    x = x0(2:end);
    N = round(T/k);				 %  number of time levels
    figure(1)
        subplot(5,1,2*i-1:2*i)
        plot(x0,u,'--');axis([0 L -0.2 1.2]);hold on
    if plt*(i==1)
        figure(2)
        subplot(3,1,i)
            plot(x0', u,'-'), hold on
       end
    for j = 1:N,	
       t = j*k;
       d = diff(u);	
       fwd = diff([u;u(1)]); 
       back = diff([u(end);u]);
       rho = zeros(size(u));  % ratio of backward to forward gradients
          q1=find(fwd~=0);% identify where no division by zero in rho
          rho(q1) = back(q1)./fwd(q1); 
    
              phi = (abs(rho)+rho)./(abs(rho)+1);		%% V-L limiter
   
         q = find(rho<=0); 
         phi(q) = zeros(size(q));
         rho(q) = 0;    % limiter is zero where rho <=0

       flux = phi.*fwd;
       u = u - c*back - cg*diff([flux(end);flux]); 
       if plt*(i==1)
        figure(2)
        subplot(3,1,i)
            plot(x0', u,'k.')
            pause(.01)
            if j<N
                unplot
            end
       end
    end
figure(1)
subplot(5,1,2*i-1:2*i)
   plot(x0,u0,'--')
   hold on
   plot(x0', u,'k.');axis([0 L -0.2 1.3]);
    text(1.7,.9,['$h = 1/' int2str(1/h) '$'],'fontsi',18);
    if i==2, xlabel('$x$','fontsi',18), end
    hold off
end
printfig('hyp_limiter',1);