%HYPERBOLIC_FIGS generates hyperbolic test problem solutions
%   Essential PDES scriptfile: DJS; 30 June 2015.

% File: hyperbolic_figs.m
% Figures 12.5, 12.7, 12.8, 12.10, 12.12
% of Essential PDEs by Griffiths, Dold & Silvester
%
% Uses the file hyp1d.m to solve the advection equation 
%   u_t+u_x=0 for 0<=x<=3
% with periodic BCs and the IC defined in Example 12.1
% and the Matlab file hyp_ic.m
% The 5 methods used are:
%   Example 12.5: FTBS,         h = 1/60, 1/240 (figure(11))
%   Example 12.7: Lax-Wendroff, h = 1/60, 1/240 (figure(12))
%   Example 12.5: Leapfrog,     h = 1/60, 1/240 (figure(13))
%   Example 12.5: 3rd order upwind, h = 1/30, 1/120 (figure(14))
%   Example 12.5: Box,          h = 1/60, 1/240 (figure(15))

setdefaults
prnt=0; % save graphics files of figures if prnt~=0
L = 3;  % Length of domain
T = 3;  % Final time
M = 180;% h = L/M
c = .45;% Courant number
a = 1;  % advection speed
plt = 0;%  plots solution on figure(plt) at every time step 
        %  on coarser grid if plt~=0
% short names 
sNames = ['ft';'lw';'lf';'qu';'bo'];
% long names
Names = {'FTBS','Lax-Wendroff','leapfrog','3rd order','box'};
base = 'hyperbolic_figs'; % 
for j = 1:5  % Loop over different methods
    M = (1+(j~=4))*90; % Number of grid points per unit distance
                       % M = 90 for j=4, otherwise M = 180.
    name = sNames(j,:);
    for i = 1:2  % Loop over grids with M & 4M points
        % 
        [x,u0,n,X,U0] = hyp1d(name,L,T,i^2*M,c,a,plt*j*(i==1));
    
    figure(10+j)
    subplot(4,1,i)
        plot(X,U0,'--',x,u0,'k.','markersi',5), hold on
        axis([0 L -.2 1.3])
        text(1.7,.9,['$h = 1/' int2str(i^2*M/L) '$'],'fontsi',18,'interp','latex');
    if i==2 
        xp = xlabel('$x$','fontsi',18);%,'interp','latex');
        pos = get(xp,'pos');
        set(xp,'pos',pos+[.3,0.2,0])
    else
        title(Names{j})
        disp(['Fig = ', int2str(j),', ' Names{j}])  
        disp(['       n = ' int2str(n) ' steps'])

    end
    stem = 'hyperbolic_figs';
    printfig(stem,j,prnt);   % save figures if prnt~=0
    end
end
