%CHAR_SOLN generates figure 4.3
%   Essential PDES scriptfile: DJS; 30 June 2015.

% File:     char_soln.m
% Created:  21 Apr 2012
% By:       dfg
% Modified: 18 May 2015
% Draws the solution in Fig. 4.3 and prints the commands to draw the
%       characteristics using pstricks
% Named as: char1-3.eps (title refers to figure 3 of file char.m)
% File char1-1.eps essentially the same as advec_sol.eps 
figure(1)
clf
setdefaults
% set(groot, 'defaultAxesTickLabelInterpreter','latex'); 
% set(groot, 'defaultLegendInterpreter','latex');
file = 'char1';
t = 0:.5:4;
x = sort([-4:.1:-1.1  1.1:.1:6  -10.^(-(0:.1:4)) 10.^(-(0:.1:4))]);
[X,T]=meshgrid(x,t);
g = inline('exp(-x.^2)');
w=waterfall(X,T,exp(-(X-T+1).^2));
set(w,'linewi',.1,'edgecol','k')
view(30,70)
colormap([0 0 0])
hold on
ax = axis;
ax(1:2) = [-4 6];
xx = -3:.2:2 -1;
axis tight
plot3([xx;xx],zeros(size([xx;xx]))-.01,...
    [g(xx+1);0*xx],'r','linewi',.2)
axis(ax)
 xlabel('$x$','fontsi',20)
 ylabel('$t$','fontsi',20)
 ylabh = get(gca,'YLabel');
set(ylabh,'Position',get(ylabh,'Position' )+ [0 1.6 0])
set(gca,'ytick',0:4,'xtick',-4:2:6)
%%%%%%%%
% define initial curve
phi = inline('x./(1+abs(x))');
% define the solution: u = S(x-t)
S = inline('.5*(x+sign(x).*sqrt(x.^2+4*abs(x)))');

%%%%%%%%
figure(3)
clf
plot3(x,phi(x),g(x),'-',x,phi(x),0*x,'-','linewi',1)
hold on
xx = 1+xx;
plot3([xx;xx],[phi(xx);phi(xx)], [g(xx);0*xx],'r','linewi',1)
tt = 1:.5:4;
[XX,TT]=meshgrid(x,tt);
ww=waterfall(XX,TT,g(S(XX-TT)));
set(ww,'linewi',.1,'edgecol','k')
axis tight
view(30,70)
grid on
 xlabel('$x$','fontsi',20)
 ylabel('$t$','fontsi',20)
 ylabh = get(gca,'YLabel');
set(ylabh,'Position',get(ylabh,'Position' )+ [0 1.6 0])
for j = 1:3
    %printfig(file,j); %eval(['print -deps '   file int2str(j)])
end
% Print commands to draw characteristics in pstricks
s = '';
for j = 1:length(x), s=[s,sprintf('(%4.2f,%6.4f)',x(j),phi(x(j)))];end
for j = length(x):-1:1, s=[s,sprintf('(%4.2f,%6.4f)',x(j),phi(x(j))-.2)];end
%%%%%%%% char coords for ex 1
for j = -4:1:6
  disp([sprintf('\\psline[linecolor=gray]{->}(%5.3f,%5.3f)(%5.3f,%5.3f)',j,-.25*j,j+6,-.25*j+3)])
end

%%%%%%%% char coords for ex 3
for j = -4:.5:6
  disp([sprintf('\\psline[linecolor=gray]{->}(%5.3f,%5.3f)(%5.3f,%5.3f)',j,phi(j),j+3,phi(j)+3)])
end