%  Example 6.14
%  File: bvpex_ad
%  Solve the ode  -eps.u" + R(x).u'(x) = rhs(x) 
%  with Dirichlet boundary conditions: u(0) = -1, u(1) = pi.
%  on 0 < x < 1 using a 2nd order method, upwind
%  method Il'in.
%  The exact solution is ex(x,par)
% Essential PDEs, Griffiths, Dold & Silvester

close all
    fj = 1;
    eps = .05;
    % definitions of functions specifying the ode    
            rhs   = @(x,b) 2*ones(size(x));
            exact = @(x,b) x-(exp(-2/b)-exp(-2*(1-x)/b))/(1-exp(-2/b));
            R     = @(x,b) 2*ones(size(x));
% fine grid & exact solution for plotting
xfine = 0:.01:1;
ufine = exact(xfine,eps);
%%%%%%%%%%%%%%%%
MM = [10 19 21];   % specify no. of grid points
error = zeros(length(MM),1);  % store max error on each grid
H = error;
for j = 1:length(MM)
   M = MM(j);
   h = 1/M;
   x = (h:h:(1-h))';
   X = [0;x;1];
   n = M-1;

   e = ones(n,1);
%	construct the coefficient matrices
   r = R(x,eps);
   D = spdiags(r,0,n,n);
   A = (eps*M^2)*spdiags(e*[-1 2 -1],-1:1,n,n);
   C = (.5*M)*spdiags(e*[-1 1],[-1 1],n,n);
   A = A+D*C;
   
%	construct the rhs 
   	
   %%%%%%%%%%%%%%%%%%%%
   f  = rhs(x,eps);
   uL = exact(0,eps);			   % u(0)
   uR = exact(1,eps);		       % u(1)
   f(1) = f(1) + uL*(eps*M^2+R(0,eps)/(2*h));			% 2nd order method
   f(n) = f(n) + uR*(eps*M^2-R(1,eps)/(2*h));
   %%%%%%%%%%%%%%%%%%%%
   	u = A\f;
    
	error(j) = norm(exact(x,eps)-u,inf);
	
	H(j) = h;
     figure(1); 
     subplot(2,3,j)
     plot(xfine,ufine,'-',X,[uL;u;uR],'.','markersi',9)
     xlabel('$x$','fontsi',14)
     set(gca,'fontsi',14)
     zh=get(gca,'xlabel');
     zv = get(zh,'Position');
     set(zh,'Position',[.75 .9*zv(2)])
     if j==1
         ax = axis;
     else
         axis(ax);
     end
     text(.2,1,['$M = $' int2str(M)],'fontsi',18)
   
end
file = 'bvpex_ad-'; % Stem of filename for saved files
     eval(['print -f1 -deps ' file '1']) 
     disp(['File: ' file  '1 printed']) 
[H error]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
