function F=cyclefigs(F)
%CYCLEFIGS cycles through the figure windows
%
%   CYCLEFIGS brings up all open figure in ascending order and pauses after
%   each figure.  When done, the figures are sorted in ascending order.

%   Author:      Peter J. Acklam
%   Time-stamp:  2000-06-07 13:31:24
%   E-mail:      jacklam@math.uio.no
%   URL:         http://www.math.uio.no/~jacklam
% Modified:      David F. Griffiths
%                1 June, 2015

if nargin<1
% Find all figure handles, sort them and count them.
  [F,n] = figs; % Call local function figs to get figure numbers
end
  F = sort(F);
  n    = length(F);
% Bring one figure up at a time.
for i = 1:n
   figure(F(i));
   if i < n
      fprintf('Press any key to display figure %i\n', F(i+1));
   pause;
   end
end
F=F(:)';
