#--------------------------------------------------------------------------------------#
# Program Name   : Chapter2_Section2.11.1 
#---------------------------------------------------------------------------------------#
start.time <- proc.time()[3]
library(tolerance)

vial <- seq(1, 6, 1)
conc <- c(102.1, 101.4, 101.0, 101.1, 100.8, 99.6)
month <- c(0, 6, 12, 18, 24, 30)

table223DS <- data.frame(Vial = vial, Concentration = conc, Time = month)
table2223DS

table223.fit <- lm(Concentration~Time, data=table223DS)
summary(table223.fit)
confint(table223.fit, 'Time', level=0.95)


newds <- data.frame(Time <- 30)

predict(table223.fit, newds, interval="confidence")
predict(table223.fit, newds, interval="prediction")
out <- regtol.int(table223.fit, new.x = 30, alpha=0.05, P=0.90, side=2)
out


cat("\n"); cat("Time Elapsed (hour): ", (proc.time()[3]-start.time)/3600, "\n")
rm(list=ls(all=TRUE))
#---------------------------------------------------------------------------------------#
#                                End of script
#---------------------------------------------------------------------------------------#