#--------------------------------------------------------------------------------------#
# Program Name   : Chapter2_Section2.11.4
#---------------------------------------------------------------------------------------#
start.time <- proc.time()[3]

expn <- seq(1, 10, 1)
lr <- c(rep (2.5, 3), rep(7.5, 4), rep(12.5, 3))
ph <- c(4.7, 5, 5.3, 4.7, 5, 5, 5.3, 4.7, 5, 5.3)
y <- c(94.01, 94.91, 99.65, 75.7, 81.54, 84.92, 91.37, 67.11, 80.62, 92.36)
table227DS <- data.frame(Experiment = expn, Loadrate=lr, pH = ph, Y =y)
table227DS

# Adding Coded variables
table227DS$lrc     <- (2*(table227DS$Loadrate) -(max(table227DS$Loadrate)+min(table227DS$Loadrate)))/(max(table227DS$Loadrate)-min(table227DS$Loadrate))
table227DS$phc     <- (2*(table227DS$pH) -(max(table227DS$pH)+min(table227DS$pH)))/(max(table227DS$pH)-min(table227DS$pH))
table227DS$lrxph   <- table227DS$Loadrate * table227DS$pH
table227DS$lrxphc  <- table227DS$lrc*table227DS$phc
table227DS

#  Analysis with uncoded data
table227.fit.uc <- lm(Y ~ Loadrate*pH, data = table227DS)
summary(table227.fit.uc)
table227.fit.uc2 <- lm(Y ~ Loadrate + pH + lrxph, data = table227DS)
summary(table227.fit.uc2)

newds <- data.frame(Loadrate = 7.5, pH = 5, lrxph = 37.5)
confint(table227.fit.uc2, c("Loadrate", "pH", "lrxph"), level = 0.95)
predict(table227.fit.uc2, newds, interval="confidence")
predict(table227.fit.uc2, newds, interval="prediction")
out <- regtol.int(table227.fit.uc2, new.x = newds, alpha=0.05, P=0.99, side=2)
out

# Analysis with coded data
table227.fit.c <- lm(Y ~ lrc + phc + lrxphc, data = table227DS)
summary(table227.fit.c)

newds1 <- data.frame(lrc = 0, phc = 0, lrxphc = 0)
confint(table227.fit.c, c("lrc", "phc", "lrxphc"), level = 0.95)
predict(table227.fit.c, newds1, interval="confidence")
predict(table227.fit.c, newds1, interval="prediction")
out1 <- regtol.int(table227.fit.c, new.x = newds1, alpha=0.05, P=0.99, side=2)
out1

# Adding quadratic term
table227DS$lr2 <- table227DS$lrc^2
table227DS$ph2 <- table227DS$phc^2

table227DS

table227.fit.sq <- lm(Y ~ lrc + phc + lrxphc + lr2 + ph2, data = table227DS)
summary(table227.fit.sq)

newds2 <- data.frame(lrc = 0, phc = 0, lrxphc = 0, lr2 = 0, ph2 = 0)
confint(table227.fit.sq, c("lrc", "phc", "lrxphc", "lr2", "ph2"), level=0.95)
predict(table227.fit.sq, newds2, interval="confidence")
predict(table227.fit.sq, newds2, interval="prediction")
out2 <- regtol.int(table227.fit.sq, new.x = newds2, alpha=0.05, P=0.99, side=2)
out2


cat("\n"); cat("Time Elapsed (hour): ", (proc.time()[3]-start.time)/3600, "\n")
rm(list=ls(all=TRUE))
#---------------------------------------------------------------------------------------#
#                                End of script
#---------------------------------------------------------------------------------------#