#--------------------------------------------------------------------------------------#
# Program Name   : Chapter2_Section2.2.3 
#---------------------------------------------------------------------------------------#
# head of script
start.time <- proc.time()[3]
# pathwd = "C:/Users/jquiroz2/PROJECTS-RESEARCH/2015/Research/CMC Book/Chapters/R codes"
# setwd(pathwd)
# Install library "qcc", if it is not installed
library("qcc")

# Data from Table 2.1
lot <- c("A", "B", "C", "D", "E",  "F", "G", "H")
purity <- c(94.20, 92.68, 94.47, 94.14, 95.17, 94.47, 94.14, 95.17)

#--- Calculate mean, variance, and standard deviation
purity.mean <- mean(purity)
purity.var <- var(purity)
purity.sd <- sd(purity)

purity.mean; purity.var; purity.sd

# Calculate confidence interval using package "qcc"
qpurity <- qcc.groups(purity, lot)
q <- qcc(qpurity, type = "xbar", std.dev = purity.sd, nsigmas=3, plot=FALSE)
process.capability(q, spec.limits=c(88, 1e4), nsigmas=3, confidence.level = 0.95,
                   restore.par = TRUE)

# Calculate confidence interval using Equation (2.6)
alpha = 0.05
cp.pe <- (purity.mean - 88)/(3*purity.sd)
n <- length(purity)
cp.lbnd <- cp.pe*(1-qnorm(1-alpha)*sqrt((1/(9*n*cp.pe^2))+(1/(2*(n-1)))))


cp.pe; cp.lbnd

# end of script
cat("\n"); cat("Time Elapsed (hour): ", (proc.time()[3]-start.time)/3600,"\n")
rm(list=ls(all=TRUE))
#---------------------------------------------------------------------------------------#
#                                End of script
#---------------------------------------------------------------------------------------#