#--------------------------------------------------------------------------------------#
# Program Name   : Chapter2_Section2.6
#---------------------------------------------------------------------------------------#
# op <- options()
# options(prompt="CMC Book> ", digits=6)

start.time <- proc.time()[3]

library("lme4")
require("nlme")

assay <- c(1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6)
aliquot <- c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)
msrmt <- c(96.672, 96.606, 96.793, 96.883, 96.253, 96.298, 96.074, 96.075, 96.098, 96.071, 96.870, 96.755)

tbl213DS <- data.frame(Assay = as.factor(assay), Aliquot = as.factor(aliquot), Reading = msrmt)
# tbl210$assay <- as.factor(tbl210$assay)
# tbl210$aliquot <- as.factor(tbl210$aliquot)
tbl213DS

#---  Results in Table 2.13  --#
anovatbl <- aov(Reading ~ Assay, data = tbl213DS)
summary(anovatbl)
msa <- summary(anovatbl)[[1]][1,3]
mse <- summary(anovatbl)[[1]][2,3]
ssa <- summary(anovatbl)[[1]][1,2]
sse <- summary(anovatbl)[[1]][2,2]
dfa <- summary(anovatbl)[[1]][1,1]
dfe <- summary(anovatbl)[[1]][2,1]

fitPurity <- lmer(Reading ~ 1 + (1|Assay), data = tbl213DS)
summary(fitPurity, ddf="Kenward-Roger")
confint(fitPurity, method="Wald", alpha= 0.95)

purity_fe    <- (summary(fitPurity))$coefficients
purity_mean  <- purity_fe[1]
purity_se    <- purity_fe[2]
df           <- length(unique(tbl213DS$Assay))-1

# Calculate confidence interval for mean
lbnd <- purity_mean - qt(0.975, df)*purity_se
ubnd <- purity_mean + qt(0.975, df)*purity_se

cimean <- data.frame(Mean=purity_mean, LBound=lbnd, UBound=ubnd)
print(cimean, digits=5)

# Calculate confidence interval for ratio of var
vcci1way  <- function(yresp, ref, ds, alpha=0.05){
  level <- 1 - alpha/2
  anovatbl <- aov(yresp~ref, data = ds)
  print(summary(anovatbl))
  out <- summary(anovatbl)
  msa <- out[[1]][1, 3]
  mse <- out[[1]][2, 3]
  dfa <- out[[1]][1, 1]
  dfe <- out[[1]][2, 1]
  # ci error
  elbnd <- dfe*mse/qchisq(level, dfe)
  eubnd <- dfe*mse/qchisq(1-level, dfe)
  error <- cbind(mse, elbnd, eubnd)
  # print(error)
  
  # ci rho
  n <- dfe/(dfa+1)+1; print(n)
  rho = (msa-mse)/(msa + (n-1)*mse)
  
  lbnd1 <- (msa/(n*qf(level, dfa, dfe)*mse))-(1/n)
  ubnd1 <- (msa/(n*qf(1-level, dfa, dfe)*mse))-(1/n)
  rlbnd <- lbnd1/(1+lbnd1)
  rubnd <- ubnd1/(1+ubnd1)
  rho <- cbind(rho, rlbnd, rubnd)
  # print(rho)
  
  # ci sigmaa
  ape <- (msa - mse)/n
  albnd <- (dfa*(msa - mse*qf(level, dfa, dfe)))/(n*qchisq(level,dfa))
  albnd <- max(0, albnd)
  aubnd <- (dfa*(msa - mse*qf(1-level, dfa, dfe)))/(n*qchisq(1-level,dfa))
  arv <- cbind(ape, albnd, aubnd)
  # print(arv)
  
  #ci total
  tpe <- (msa + (n-1)*mse)/n
  G1 <- 1 - (dfa/qchisq(level, dfa))
  G2 <- 1 - (dfe/qchisq(level, dfe))
  H1 <- (dfa/qchisq(1-level, dfa)) -1
  H2 <- (dfe/qchisq(1-level, dfe)) -1
  # print(c(G1, G2, H1, H2))
  
  varl <- (G1*msa/n)^2 + (G2*(n-1)*mse/n)^2
  varu <- (H1*msa/n)^2 + (H2*(n-1)*mse/n)^2
  
  tlbnd <- tpe - sqrt(varl)
  tubnd <- tpe + sqrt(varu)
  total <- cbind(tpe, tlbnd, tubnd)
  # print(total)
  
  answer <- rbind(error, rho, arv, total)
  colnames(answer) <- c("Point Estimate", "Lower bound", "Upper bound")
  rownames(answer) <- c("Residual", "Rho", "A Effect", "Total Var.")
  return(answer)
  
}
ans <- vcci1way(tbl213DS$Reading, tbl213DS$Assay, tbl213DS, alpha = 0.05)  
print( ans, digits=4)


#---       Prediction for next observed value        ---#
#---    Tolerance intervals for future process value ---#
ptol1way <- function(yresp, xvar, ds, content, alpha){
  #print(ds)
  level <- 1 - alpha/2
 # xvar <- as.factor(xvar)
  anovatbl <- aov(yresp ~ xvar, data = ds)
  
  print(summary(anovatbl))
  out <- summary(anovatbl)
  msa <- out[[1]][1, 3]
  mse <- out[[1]][2, 3]
  dfa <- out[[1]][1, 1]
  dfe <- out[[1]][2, 1]
  
  a <- dfa + 1
  n <- (dfe/(dfa+1))+1
  
  # upper bound on U 
  tpe <- (msa + (n-1)*mse)/n
  H1 <- (dfa/qchisq(alpha, dfa)) -1
  H2 <- (dfe/qchisq(alpha, dfe)) -1
  varu <- (H1*msa/n)^2 + (H2*(n-1)*mse/n)^2
  
  tubnd <- tpe + sqrt(varu)
  # print(tubnd)
  
  # compute ne and r 
  ne <- (a*n*tpe)/msa
  r <- sqrt(1 + 1/ne)
  zvalue <- qnorm((1 + content)/2)
  ybar <- mean(yresp)
  #print(c(ybar, ne, zvalue, r, tubnd, tpe))
  
  # tolerance interval
  tolubnd <- ybar + zvalue*r*sqrt(tubnd)
  tollbnd <- ybar - zvalue*r*sqrt(tubnd)
  tolint <- cbind(ybar, tollbnd, tolubnd, 1-alpha)
  
  # prediction interval
  R <- max(0, (msa - mse)/(n*mse))
  B <- sqrt((R+1)/(n*R+1)) 
  m <- (tpe^2)/((msa^2)/(dfa*n^2) + (dfa*mse^2)/(a*n^2))
  K <- qt(level, df=m)*sqrt(1 + 1/(a*n*B^2))
  prelbnd <- ybar - K*sqrt(tpe)
  preubnd <- ybar + K*sqrt(tpe)
  #print (c(R, B, m, K))
  predint <- cbind(ybar, prelbnd, preubnd, 1-alpha)
  
  answer <- rbind(predint, tolint)
  colnames(answer) <- c("Average", "Lower bound", "Upper bound", "Level")
  rownames(answer) <- c("Prediction Interval", "Tolerance Interval")
  return(answer)
}

result <- ptol1way(tbl213DS$Reading, tbl213DS$Assay, ds=tbl213DS, content=0.99, alpha=0.05)
print(round(result, digits=4))

cat("\n"); cat("Time Elapsed (hour): ", (proc.time()[3]-start.time)/3600, "\n")
rm(list=ls(all=TRUE))

#---------------------------------------------------------------------------------------#
#                                End of script
#---------------------------------------------------------------------------------------#