*-------------------------------------------------------------
* Program	:  Chapter2_Section2.11.4
*--------------------------------------------------------------;
options ls = 74;
data tbl227ds;
	input Experiment Loadrate pH Y lrc phc;
datalines;
1	2.5		4.7		94.01	-1	   -1
2	2.5		5.0		94.91	-1		0
3	2.5		5.3		99.65	-1		1
4	7.5		4.7		75.70 	 0	   -1
5	7.5		5.0		81.54    0      0
6	7.5		5.0		84.92    0      0
7	7.5		5.3		91.37    0      1
8	12.5	4.7		67.11    1     -1
9	12.5	5.0		80.62    1      0
10	12.5	5.3		92.36    1      1
;

data tbl227ds;
	set tbl227ds;
	lrxphc = lrc*phc;
	ph2 = phc*phc;
	lr2 = lrc*lrc;
run;

proc print data = tbl227ds;
run;

ods graphics off;
proc glm data = tbl227ds;
	model Y = Loadrate|pH   / clparm clm;
	output out = pred227nc
		predicted = predvalues
        lcl = lcipred	ucl = ucipred
		lclm = lcimean  uclm = ucimean;
run;

proc glm data = tbl227ds;
	model Y = lrc|phc   / clparm clm;
	output out = pred227c
		predicted = predvalues
        lcl = lcipred	ucl = ucipred
		lclm = lcimean  uclm = ucimean;
run;
ods graphics on;
proc print data = pred227nc;
run;

proc print data = pred227c;
run;

ods graphics off;
proc glm data = tbl227ds;
	model Y = lrc|phc lr2 ph2 / clparm clm;
	output out = pred227c2
		predicted = predvalues
        lcl = lcipred	ucl = ucipred
		lclm = lcimean  uclm = ucimean;
run;
ods graphics on;

proc print data = pred227c2;
run;

*-------------------------------------------------------------*
*						End of File							  *
*-------------------------------------------------------------*;
