*-------------------------------------------------------------
* Program	:  Chapter2_Section2.11.5
*--------------------------------------------------------------;

options ls = 74;

data tbl236;
	input Lot $ Vial Concentration Time;
datalines;
A	1	102.1	0
A	2	101.4	6
A	3	101.0	12
A	4	101.1	18
A	5	100.8	24
A   6    99.6   30
B	7	100.0	0
B	8	100.0	6
B	9	100.2	12
B	10	98.8	18
B	11	99.8	24
B	12	99.0   30
C	13	97.6	0
C	14	98.3	6
C	15	98.1	12
C	16	97.1	18
C	17	96.5	24
C	18  96.0   30
;

proc print data = tbl236;
run;
data tbl236ds;
	set tbl236;
	if Lot = "A"  then lota = 1;
	if Lot = "C"  then lota = -1;
	if Lot = "B"  then lota = 0;
	if Lot = "B"  then lotb = 1;
	if Lot = "C"  then lotb = -1;
	if Lot = "A"  then lotb = 0;
	laxt = Time*lota;
	lbxt = Time*lotb;
run;
proc print data = tbl236ds;
run;

ods graphics off;
proc glm data = tbl236ds;
	model Concentration = Time	lota lotb / clparm clm;
	  output out = pred236
		predicted = predvalues
        lcl = lcipred	ucl = ucipred
		lclm = lcimean  uclm = ucimean;
run;
ods graphics on;

proc print data = pred236;
run;

ods graphics off;
proc glm data = tbl236ds;
	model Concentration = Time	lota lotb laxt  lbxt / clparm clm;
	  output out = pred236ind
		predicted = predvalues
        lcl = lcipred	ucl = ucipred
		lclm = lcimean  uclm = ucimean;
run;
ods graphics on;

proc print data = pred236ind;
run;
*-------------------------------------------------------------*
*						End of File							  *
*-------------------------------------------------------------*;
