*-------------------------------------------------------------
* Program	:  Chapter2_Section2.11.6
*--------------------------------------------------------------;

options ls = 74;
data tbl243ds;
	input Lot $ Vial Concentration Time;
datalines;
A	1	102.1	0
A	2	101.4	6
A	3	101.0	12
A	4	101.1	18
A	5	100.8	24
A   6    99.6   30
B	7	100.0	0
B	8	100.0	6
B	9	100.2	12
B	10	98.8	18
B	11	99.8	24
B	12	99.0   30
C	13	97.6	0
C	14	98.3	6
C	15	98.1	12
C	16	97.1	18
C	17	96.5	24
C	18  96.0   30
;

proc print data = tbl243ds;
run;

proc mixed data = tbl243ds;
	class Lot;
	model Concentration = Time / solution cl;
	random Lot / solution ;
	estimate "No Random effect" intercept 1 Time 30 / cl;
	estimate "BLUP Lot A at 30 month" intercept 1 Time 30 | Lot 1 0 0 /cl ;
run;
*-------------------------------------------------------------*
*						End of File							  *
*-------------------------------------------------------------*;
