*-------------------------------------------------------------
* Program	:  Chapter2_Section2.6
*--------------------------------------------------------------;

data tbl213ds;
	input Assay $ Aliquot  Reading;
datalines;
1	1	96.672
1	2	96.606
2	3 	96.793
2	4	96.883
3	5	96.253
3	6	96.298
4	7	96.074
4	8	96.075
5	9	96.098
5	10	96.071
6	11	96.870
6	12	96.755
;
run;
proc print data = tbl213ds;
run;

proc mixed data = tbl213ds method=type3;
	class Assay;
	model Reading = / s cl;
	random  Assay ;
	ods output type3  = mytype3;
	ods output SolutionF = mymean;
run;
/*ods select all;*/
/* proc contents data = mytype3;
run; */
proc print data = mymean;
run;

proc iml;
	use mymean;
		read all;
		ybar = Estimate;
	*print ybar;
	alpha = 0.05; content = 0.99;
	level = 1- alpha/2;
	use mytype3;
	read all ;
	aovtb = DF||SS||MS;
	*print aovtb x;
	sa2 = aovtb[1,3];   dfa = aovtb[1,1];
	se2 = aovtb[2,3];   dfe = aovtb[2,1];
	*print sa2 se2 dfa dfe;
	/*  Confidence interval for error */
	elbnd = (dfe*se2)/cinv(level, dfe);
	eubnd = (dfe*se2)/cinv(1-level, dfe);
	residual = se2||elbnd||eubnd;
	*print residual;
	/*  Confidence interval for rho */
	n = dfe/(dfa+1) +1;
	l1 = sa2/(n*finv(level, dfa, dfe)*se2) - 1/n;
	u1 = sa2/(n*finv(1-level, dfa, dfe)*se2) - 1/n;
	rlbnd = l1/(1+l1);   rubnd = u1/(1+u1);
	rest = (sa2 - se2)/(sa2 + (n-1)*se2);
	rho = rest||rlbnd||rubnd;
	*print rho;
	/* Confidence interval for analyst */
	aest = (sa2 - se2)/n;
	albnd = dfa*(sa2 - se2*finv(level, dfa, dfe))/(n*cinv(level, dfa));
    aubnd = dfa*(sa2 - se2*finv(1-level, dfa, dfe))/(n*cinv(1-level, dfa));
	analyst = aest||albnd||aubnd;
	*print analyst;
	/* Confidence interval for total var */
	tvest = (sa2 + (n-1)*se2)/n;
	G1 = 1 - (dfa/cinv(level, dfa));
	G2 = 1 - (dfe/cinv(level, dfe));
	H1 = (dfa/cinv(1-level, dfa))-1;
	H2 = (dfe/cinv(1-level, dfe))-1;
	vl = (G1*sa2/n)**2 + ((n-1)*G2*se2/n)**2;
	vu = (H1*sa2/n)**2 + ((n-1)*H2*se2/n)**2;
	tvlbnd = tvest - sqrt(vl);
	tvubnd = tvest + sqrt(vu);
	totalvar = tvest||tvlbnd||tvubnd;
	*print totalvar;
	
	/* prediction interval for next obs */
	R = max(0, (sa2 - se2)/(n*se2));
	B = sqrt((R+1)/(n*R + 1));
	m = (tvest**2)/( (sa2**2/((dfa)*n*n)) + (dfa*se2**2)/((dfa+1)*n*n));
	K = tinv(level,m)*sqrt(1 + 1/((dfa+1)*n*B*B));
	plbnd = ybar - K*sqrt(tvest);
	pubnd = ybar + K*sqrt(tvest);
	predci = ybar||plbnd||pubnd;
	*print R B m K predci;
	/* H-K tolerance interval  */
    h1 = (dfa/cinv(alpha, dfa))-1;
	h2 = (dfe/cinv(alpha, dfe))-1;
	vul = (h1*sa2/n)**2 + ((n-1)*h2*se2/n)**2;
	u95 = tvest + sqrt(vul);
	ne = ((dfa+1)*n*tvest)/sa2;
	rterm = sqrt(1 + (1/ne));
	zvalue = probit((1+content)/2);
	*print ne rterm zvalue u95 tvest;
	tollow = ybar - zvalue*rterm*sqrt(u95);
	tolup =  ybar + zvalue*rterm*sqrt(u95);
	tolint = ybar||tollow||tolup;
	*print tolint;
	answer = (residual//rho//analyst//totalvar//predci//tolint);
	create outci var{Estimate Lbnd Ubnd};
		append from answer;
	close outci;
run;
quit;

data outname;
	length Parameter $ 12;
	input Parameter $;
datalines;
Residual
Rho
Analyst
TotalVar
Prediction
Tolerance
;

data outci2;
	merge outname outci;
run;

proc print data = outci2;
run;
*--------------------------------------------------------------
*						End of File
*--------------------------------------------------------------;
