ability <- function(mdl, u, b, a, c) {
  J <- length(b)
  if (mdl == 1 | mdl == 2 | missing(c)) {
    c <- rep(0, J)
  }
  if (mdl == 1 | missing(a)) { a <- rep(1, J) }
  x <- sum(u)
  if (x == 0) {
    th <- -log(2 * J)
  }
  if (x == J) {
    th <- log(2 * J)
  }
  if (x == 0 | x == J) {
    sumdem <- 0.0
    for (j in 1:J) {
      pstar <- 1 / (1 + exp(-a[j] * (th - b[j])))
      phat <- c[j] + (1.0 - c[j]) * pstar
      sumdem <- sumdem - a[j]**2 * phat * (1.0 - phat) *
        (pstar / phat)**2
    }
    se <- 1 / sqrt(-sumdem)
  }
  if (x != 0 & x != J) {
    th <- log(x / (J - x))
    S <- 10
    ccrit <- 0.001
    for (s in 1:S) {
      sumnum <- 0.0
      sumdem <- 0.0
      for (j in 1:J) {
        pstar <- 1 / (1 + exp(-a[j] * (th - b[j])))
        phat <- c[j] + (1.0 - c[j]) * pstar
        sumnum <- sumnum + a[j] * (u[j] - phat) *
          (pstar / phat)
        sumdem <- sumdem - a[j]**2 * phat * (1.0 - phat) *
          (pstar / phat)**2
      }
      delta <- sumnum / sumdem
      th <- th - delta
      if (abs(delta) < ccrit | s == S) {
        se <- 1 / sqrt(-sumdem)
        break
      }
    }
  }
  cat(paste("th=", th, "\n")); flush.console()
  cat(paste("se=", se, "\n")); flush.console()
  thse <- c(th, se)
  return(thse)
}
