groupinv <- function(mdl, t1l, t1u, t2l, t2u) {
  if (missing(t1l)) t1l <- -3
  if (missing(t1u)) t1u <- -1
  if (missing(t2l)) t2l <- 1
  if (missing(t2u)) t2u <- 3
  theta <- seq(-3, 3, .1875)
  f <- rep(21, length(theta))
  wb <- round(runif(1,-3,3), 2)
  wa <- round(runif(1,0.2,2.8), 2)
  wc <- round(runif(1,0,.35), 2)
  if (mdl == 1 | mdl == 2) { wc <- 0 }
  if (mdl == 1) { wa <- 1 }
  for (g in 1:length(theta)) {
    P <- wc + (1 - wc) / (1 + exp(-wa * (theta - wb)))
  }
  p <- rbinom(length(theta), f, P) / f
  lowerg1 <- 0
  for (g in 1:length(theta)) {
    if (theta[g] <= t1l) { lowerg1 <- lowerg1 + 1 }
  }
  upperg1 <- 0
  for (g in 1:length(theta)) {
    if (theta[g] <= t1u) { upperg1 <- upperg1 + 1 }
  }
  theta1 <- theta[lowerg1:upperg1]
  p1 <- p[lowerg1:upperg1]
  lowerg2 <- 0
  for (g in 1:length(theta)) {
    if (theta[g] <= t2l) { lowerg2 <- lowerg2 + 1 }
  }
  upperg2 <- 0
  for (g in 1:length(theta)) {
    if (theta[g] <= t2u) { upperg2 <- upperg2 + 1 }
  }
  theta2 <- theta[lowerg2:upperg2]
  p2 <- p[lowerg2:upperg2]
  theta12 <- c(theta1, theta2)
  p12 <- c(p1, p2)
  par(lab=c(7,5,3))
  plot(theta12, p12, xlim=c(-3,3), ylim=c(0,1),
    xlab="Ability", ylab="Probability of Correct Response")
  if (mdl == 1) {
    maintext <- paste("Pooled Groups", "\n", "b=", wb)
  }
  if (mdl == 2) {
    maintext <- paste("Pooled Groups","\n","a=",wa,"b=",wb)
  }
  if (mdl == 3) {
    maintext <- paste("Pooled Groups", "\n",
      "a=", wa, "b=", wb, "c=", wc)
  }
  par(new="T")
  plot(theta, P, xlim=c(-3,3), ylim=c(0,1), type="l",
    xlab="", ylab="", main=maintext)
}
