iccfit <- function(mdl) {
  theta <- seq(-3, 3, .1875)
  f <- rep(21, length(theta))
  wb <- round(runif(1,-3,3), 2)
  wa <- round(runif(1,0.2,2.8), 2)
  wc <- round(runif(1,0,.35), 2)
  if (mdl == 1 | mdl == 2) { wc <- 0 }
  if (mdl == 1) { wa <- 1 }
  for (g in 1:length(theta)) {
    P <- wc + (1 - wc) / (1 + exp(-wa * (theta - wb)))
  }
  p <- rbinom(length(theta), f, P) / f
  par(lab=c(7,5,3))
  plot(theta, p, xlim=c(-3,3), ylim=c(0,1),
    xlab="Ability", ylab="Probability of Correct Response")
  cs <- 0
  for (g in 1:length(theta)) {
    v <- f[g] * (p[g] - P[g])^2 / (P[g] - P[g]^2)
    cs <- cs + v
  }
  cs <- round(cs, 2)
  if (mdl == 1) {
    maintext <- paste("Chi-square=", cs, "\n", "b=", wb)
  }
  if (mdl == 2) {
    maintext <- paste("Chi-square=",cs,"\n","a=",wa,"b=",wb)
  }
  if (mdl == 3) {
    maintext <- paste("Chi-square=", cs, "\n",
      "a=", wa, "b=", wb, "c=", wc)
  }
  par(new="T")
  plot(theta, P, xlim=c(-3,3), ylim=c(0,1), type="l",
    xlab="", ylab="", main=maintext)
}
