tcc <- function(b, a, c) {
  J <- length(b)
  if (missing(c)) c <- rep(0, J)
  if (missing(a)) a <- rep(1, J)
  theta <- seq(-3, 3, .1)
  ts <- rep(0, length(theta))
  for (j in 1:J) {
    P <-  c[j] + (1 - c[j]) / (1 + exp(-a[j]*(theta-b[j])))
    ts <- ts + P
  }
  plot(theta, ts, type="l", xlim=c(-3,3), ylim=c(0,J),
    xlab="Ability", ylab="True Score",
    main="Test Characteristic Curve")
}

