tif <- function(b, a, c) {
  J <- length(b)
  if (missing(c)) c <- rep(0, J)
  if (missing(a)) a <- rep(1, J)
  theta <- seq(-3, 3, 0.1)
  ii <- matrix(rep(0, length(theta)*J), nrow=length(theta))
  i <- rep(0, length(theta))
  for (j in 1:J) {
    Pstar <- 1 / (1 + exp(-a[j] * (theta - b[j])))
    P <- c[j] + (1 - c[j]) * Pstar
    ii[,j] <- a[j]**2 * P * (1.0 - P) * (Pstar / P)**2
    i <- i + ii[,j]
  }
  plot(theta, i, xlim=c(-3,3), ylim=c(0,10), type="l",
    xlab="Ability", ylab="Information",
    main="Test Information Function")
}
