﻿(function () {
    "use strict";
    var fs = null; // Das Dateisystem als global zugängliche Variable
    document.addEventListener('deviceready', onDeviceReady.bind(this),
     false);
    function onDeviceReady() {
        window.requestFileSystem(window.PERSISTENT, 0, onInitFs, onError);
        // Erstellen einer Datei mit Content
        $("#wrt").click(function () {
            fs.root.getFile('applog.txt', { create: true, exclusive: true },
              function (fileEntry) {
                  // FileWriter-Objekt erstellen
                  fileEntry.createWriter(function (fileWriter) {

                      fileWriter.onwriteend = function (e) {
                          $("#info").html('Erstellen fertig.');
                      };
                      fileWriter.onerror = function (e) {
                          $("#info").html('Fehler beim Schreiben: ' + e.toString());
                      };
                      // Blob erzeugen und in die Datei schreiben.
                      var blob = new Blob(['Aktuelles Datum: ' + new Date()],
                        { type: 'text/plain' });
                      fileWriter.write(blob);
                  })
              }, function () {
                  $("#info").html('Fehler beim Erstellen der Datei');
              });
        });
        // Lesen einer Datei mit Content
        $("#rd").click(function () {
            fs.root.getFile('applog.txt', {}, function (fileEntry) {
                // Ein File-Objekt bekommen und dann mit 
                // FileReader den Inhalt lesen
                fileEntry.file(function (file) {
                    var reader = new FileReader();
                    reader.onloadend = function (e) {
                        $("#info").html("Inhalt der Datei:<hr />" + this.result);
                    };
                    reader.readAsText(file);
                })
            }, function () {
                $("#info").html('Fehler beim Einlesen der Datei');
            });
        });
        // Anhängen
        $("#apd").click(function () {
            fs.root.getFile('applog.txt', { create: false }, function (fileEntry) {
                // FileWriter-Objekt erstellen
                fileEntry.createWriter(function (fileWriter) {

                    fileWriter.seek(fileWriter.length); // Start Schreibposition EOF
                    var neuContent = 'Zufallszahl: ' + Math.random();
                    // Neuer Blob und anhängen
                    var blob = new Blob(['<br />' + neuContent],
                      { type: 'text/plain' });
                    fileWriter.write(blob);
                    $("#info").html("\"" + neuContent + '" an die Datei angehängt');
                })
            }, function () {
                $("#info").html(
                  'Fehler beim Anh&auml;ngen von Inhalt an die Datei');
            });
        });
        // Löschen
        $("#del").click(function () {
            fs.root.getFile('applog.txt', { create: false },
            function (fileEntry) {
                fileEntry.remove(function () {
                    $("#info").html('Datei gel&ouml;scht');
                })
            },
            function () {
                $("#info").html('Fehler beim L&ouml;schen der Datei');
            });
        });
    };
    function onError(err) {
        $("#info").html('Fehler beim Oeffnen des Dateisystems: ' + err.name);
        $("a").addClass('ui-disabled');
    }
    function onInitFs(files) {
        $("#dat").html('Dateisystem geoeffnet: ' + files.name + "<hr />");
        fs = files;
        $("a").removeClass('ui-disabled');
    }
})();
