﻿(function () {
    "use strict";
    document.addEventListener('deviceready', onDeviceReady.bind(this),
      false);
    function onDeviceReady() {
        var requestedBytes = 1024 * 1024 * 280;
        window.requestFileSystem(window.PERSISTENT, 0, onInitFs, onError);
    };
    function onInitFs(fs) {
        document.getElementById("info").innerHTML = 'Dateisystem geoeffnet: '
          + fs.name + "<hr />";
        for (var i in fs) {
            document.getElementById("info").innerHTML += i + ":" + fs[i]
              + "<br />";
        }
        document.getElementById("info").innerHTML += "<hr />";
        for (var i in fs.root) {
            document.getElementById("info").innerHTML += i + ":" + fs.root[i]
              + "<br />";
        }
    }
    function onError(err) {
        document.getElementById("info").innerHTML =
          'Fehler beim Oeffnen des Dateisystems: ' + err.name;
    }
})();
