﻿(function () {
    "use strict";
    document.addEventListener('deviceready', onDeviceReady.bind(this),
      false);
    function onDeviceReady() {
        var requestedBytes = 1024 * 1024 * 280;
        window.requestFileSystem(window.PERSISTENT, 0, onInitFs, onError);
    };
    function onInitFs(fs) {
        document.getElementById("info").innerHTML = 'Dateisystem geoeffnet: '
          + fs.name + "<hr />";
        fs.root.getFile('applog.txt', { create: true, exclusive: true },
          function (fileEntry) {
              for (var i in fileEntry) {
                  document.getElementById("info").innerHTML += i + ":" + fileEntry[i] + "<br />";
              }
          }, function () {
              document.getElementById("info").innerHTML = 'Fehler beim Erstellen der Datei';
          });
    }
    function onError(err) {
        document.getElementById("info").innerHTML = 'Fehler beim Oeffnen des Dateisystems: ' + err.name;
    }
})();
