﻿var request = window.indexedDB.open("buecher");
var db;

(function () {
    "use strict";

    document.addEventListener( 'deviceready', onDeviceReady.bind( this ), false );

    function onDeviceReady() {
        request.onupgradeneeded = function () {
            // Wenn Datenbank nicht vorhanden erstellen
            db = request.result;
            var store = db.createObjectStore("buecher", {
                keyPath: "isbn"
            });
            var titleIndex = store.createIndex("titel", "titel", {
                unique: true
            });
            var authorIndex = store.createIndex("autor", "autor");

            // Einige Daten zur Initialisierung anlegen
            store.put({
                titel: "WordPress",
                autor: "Ralph Steyer",
                isbn: 9783658128296
            });
            store.put({
                titel: "Joomla!",
                autor: "Ralph Steyer",
                isbn: 9783658088781
            });

        };

        request.onsuccess = function () {
            db = request.result;
            $("#info").html("Datenbank erstellt und initialisiert.<hr />Folgende Datensätze sind schon vorhanden:<br />");
            var tx = db.transaction("buecher", "readonly");
            var store = tx.objectStore("buecher");

            store.openCursor().onsuccess = function (event) {
                var cursor = event.target.result;
                if (cursor) {
                    $("#info").append(cursor.value.isbn + ", " + cursor.value.titel + "," + cursor.value.autor + "<br />");
                    cursor.continue();
                }
            };

        };
    };
    $("#erstellen").click(function () {
        var tx = db.transaction("buecher", "readwrite");
        var store = tx.objectStore("buecher");
        var titel = $("#titel").val();
        var autor = $("#autor").val();
        var isbn = $("#isbn").val();
        if ((titel == "") || (autor == "") || (isbn == "")) {
            $("#info").html("Die Daten müssen vollständig sein. Es wurde kein Datensatz hinzugefügt.");
            return;
        }
        store.put({
            titel: titel,
            autor: autor,
            isbn: isbn
        });

        tx.oncomplete = function () {
            $("#info").html("Neuer Datensatz " + titel + ", " + autor + ", " + isbn + ", " + " hinzugefügt.");
            $("#titel").val("");
            $("#autor").val("");
            ("#isbn").val("");

        };
    });
    $("#anzeigen").click(function () {
        var tx = db.transaction("buecher", "readonly");
        var store = tx.objectStore("buecher");
        var index = store.index("autor");
        var counter = 0;
        var suchbegriff = $("#suche_autor").val();
        $("#ausgabe").html("");

        var request = index.openCursor(IDBKeyRange.only(suchbegriff));
        request.onsuccess = function () {
            var cursor = request.result;
            if (cursor) {
                counter++;
                $("#ausgabe").append(cursor.value.isbn + ", " + cursor.value.titel + "," + cursor.value.autor + "<br />");
                cursor.continue();
            } else {

                $("#info").html("Suche nach dem Suchbegriff '" + suchbegriff + "' durchgeführt. Es gab " + counter + " Treffer.");
            }
        };

    });

    $("#ds_loeschen").click(function () {
        var tx = db.transaction("buecher", "readwrite");
        var store = tx.objectStore("buecher");
        var suchbegriff = $("#suche_autor").val();

        store.openCursor().onsuccess = function (event) {
            var cursor = event.target.result;
            if (cursor) {
                if (cursor.value.autor == suchbegriff) {
                    var request = cursor.delete();
                    request.onsuccess = function () {
                        $("#info").html("Alle Datensätze, die mit dem Suchbegriff '" + suchbegriff + "' übereinstimmen, wurden gelöscht.");
                    };
                }
                cursor.continue();
            }
        };

    });

    $("#db_leeren").click(function () {
        var tx = db.transaction("buecher", "readwrite");
        var store = tx.objectStore("buecher");
        store.clear();
        $("#info").html("Die Datenbank wurde komplett geleert.");
        $("#ausgabe").html("");

    });

    $("#db_loeschen").click(function () {
        db.close();
        var req = window.indexedDB.deleteDatabase("buecher");
        req.onsuccess = function () {
            $("#info").html("Datenbank gelöscht.");
            $("#ausgabe").html("");
            $(".btn").addClass("disabled");

        };
        req.onerror = function () {
            $("#info").html("Datenbank konnte nicht gelöscht werden");
        };
        req.onblocked = function () {
            $("#info").html("Datenbank konnte nicht gelöscht werden, da im Moment blockiert");
        };
    });

} )();